/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.file;

import cn.gtmap.hlw.core.util.date.DateUtils;
import cn.gtmap.hlw.core.util.thread.ThreadPoolMdcExecutor;
import cn.hutool.core.io.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileUtils {
    private static final Logger logger = LoggerFactory.getLogger(LogFileUtils.class);

    public static void writeToFileAsync(String content, String slbh) {
        String uploadFilePath = "/pushDjJson/";
        File dir = new File(uploadFilePath);
        if (!dir.exists()) {
            FileUtil.mkdir((String)uploadFilePath);
        }
        String filePath = uploadFilePath + DateUtils.dateToStr(new Date(), "yyyyMMddHHmmss") + "-" + slbh + ".txt";
        int CHUNK_SIZE = 0x100000;
        ThreadPoolMdcExecutor.execute(() -> {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                int contentLength = content.length();
                int offset = 0;
                while (offset < contentLength) {
                    int end = Math.min(offset + 0x100000, contentLength);
                    writer.write(content, offset, end - offset);
                    offset = end;
                }
                logger.info("\u6570\u636e\u5df2\u6210\u529f\u5199\u5165\u6587\u4ef6: {}", (Object)filePath);
            }
            catch (IOException e) {
                logger.error("\u5199\u5165\u6587\u4ef6\u65f6\u51fa\u9519\uff0c\u6587\u4ef6\u8def\u5f84: {}\uff0c\u9519\u8bef\u4fe1\u606f: {}", new Object[]{filePath, e.getMessage(), e});
            }
        });
    }
}

