/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption.sm4;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CipherUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CipherUtil.class);
    protected static final String SHA1_SECURE_RANDOM = "SHA1PRNG";
    protected static final String NATIVE_SECURE_RANDOM = "NativePRNG";

    public static byte[] encrypt(byte[] msgBytes, byte[] keyBytes, byte[] ivBytes, String algorithmName, String cipherAlgorithm) {
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, algorithmName);
            if (ivBytes != null) {
                IvParameterSpec paramSpec = new IvParameterSpec(ivBytes);
                cipher.init(1, (Key)secretKeySpec, paramSpec);
            } else {
                cipher.init(1, secretKeySpec);
            }
            return cipher.doFinal(msgBytes);
        }
        catch (Exception e) {
            LOGGER.error("{}\u52a0\u5bc6\u5931\u8d25\uff1a{}", (Object)algorithmName, (Object)e);
            return null;
        }
    }

    public static byte[] decrypt(byte[] msgBytes, byte[] keyBytes, byte[] ivBytes, String algorithmName, String cipherAlgorithm) {
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, algorithmName);
            if (ivBytes != null) {
                IvParameterSpec paramSpec = new IvParameterSpec(ivBytes);
                cipher.init(2, (Key)secretKeySpec, paramSpec);
            } else {
                cipher.init(2, secretKeySpec);
            }
            return cipher.doFinal(msgBytes);
        }
        catch (Exception e) {
            LOGGER.error("{}\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)algorithmName, (Object)e);
            return null;
        }
    }

    public static byte[] generateKey(String algorithmName, int keySize) {
        return CipherUtil.generateKey(algorithmName, keySize, null);
    }

    public static byte[] generateKey(String algorithmName, int keySize, SecureRandom secureRandom) {
        byte[] keyBytes = null;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithmName);
            if (secureRandom != null) {
                keyGenerator.init(keySize, secureRandom);
            } else {
                keyGenerator.init(keySize);
            }
            SecretKey secretKey = keyGenerator.generateKey();
            keyBytes = secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("\u751f\u6210{}\u5bc6\u94a5\u5931\u8d25\uff1a{}", (Object)algorithmName, (Object)e);
        }
        return keyBytes;
    }

    static {
        if (null == Security.getProvider("BC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

