package cn.gtmap.hlw.core.dto.zwfw;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import lombok.Data;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2025/8/7
 * @description
 */
@Data
@XStreamAlias("ATTR")
public class AttrInfoDTO {
    /**
     *唯一标识
     */
    @XStreamAlias("UNID")
    private String unid;
    /**
     *办件编号
     */
    @XStreamAlias("PROJID")
    private String projid;
    /**
     *材料标识
     */
    @XStreamAlias("ATTRID")
    private String attrid;
    /**
     *材料名称
     */
    @XStreamAlias("ATTRNAME")
    @ZdDzConfig(field = "attrname", tableName = ZdDzConstant.ZD_DZ_FJLX, mcToDM = true)
    private String attrname;
    /**
     *材料序号
     */
    @XStreamAlias("SORTID")
    private String sortid;
    /**
     *收取方式
     */
    @XStreamAlias("TAKETYPE")
    private String taketype;
    /**
     *是否收取
     */
    @XStreamAlias("ISTAKE")
    private String istake;
    /**
     * 附件文件名称
     */
    @XStreamAlias("FILENAME")
    private String filename;
    /**
     * 附件文件大小
     */
    @XStreamAlias("FILE_SIZE")
    private String file_size;
    /**
     * 附件提取标识
     */
    @XStreamAlias("FILEID")
    private String fileid;
    /**
     * 附件来源
     */
    @XStreamAlias("ARRTSOURCE")
    private String arrtsource;
    /**
     * 来源编码
     */
    @XStreamAlias("ARRTSOURCECODE")
    private String arrtsourcecode;
    /**
     * 收取数量
     */
    @XStreamAlias("AMOUNT")
    private String amount;
    /**
     * 收取时间
     */
    @XStreamAlias("TAKETIME")
    private String taketime;
    /**
     * 备注
     */
    @XStreamAlias("MEMO")
    private String memo;
}
