package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyLcdyPz;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;

import java.util.List;
import java.util.Map;

/**
 * 流程打印配置(GxYyLcdyPz)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-10 15:19:36
 */
public interface GxYyLcdyPzRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param pzid 主键
     * @return 实例对象
     */
    GxYyLcdyPz get(String pzid);

    /**
     * 新增数据
     *
     * @param gxYyLcdyPz 实例对象
     * @return 影响行数
     */
    void save(GxYyLcdyPz gxYyLcdyPz);

    /**
     * 修改数据
     *
     * @param gxYyLcdyPz 实例对象
     * @return 影响行数
     */
    void update(GxYyLcdyPz gxYyLcdyPz);
    /**
     * 获取数据
     *
     * @param paramsModel 查询对象
     * @return 影响行数
     */
    GxYyLcdyPz getByParams(GeneratePdfParamsModel paramsModel);

    /**
     * 查询流程打印配置
     * @param paramMap
     * @return:List<GxYyLcdyPz>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyLcdyPz> getListByMap(Map<String, Object> paramMap);

    /**
     * 根据区域代码和文件名称查询
     *
     * @param qydm
     * @param filenameCqcx
     * @return:GxYyLcdyPz
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyLcdyPz getByQydmAndWjmc(String qydm, String filenameCqcx);

    /**
     * 根据申请类型和区域代码查询
     *
     * @param sqlx 申请类型
     * @param qydm 区域代码
     * @return:List<GxYyLcdyPz>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyLcdyPz> getBySqlxAndQydm(String sqlx, String qydm);

    /**
     * 根据申请类型和区域代码查询签字板配置
     *
     * @param sqlx 申请类型
     * @param qydm 区域代码
     * @return:List<GxYyLcdyPz>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyLcdyPz> getQzbPzBySqlxAndQydm(String sqlx, String qydm);

    /**
     * 根据申请类型和区域代码查询
     *
     * @param sqlx 申请类型
     * @param qydm 区域代码
     * @param fjlx 附件类型
     * @return:List<GxYyLcdyPz>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyLcdyPz> getBySqlxAndQydmAndFjlx(String sqlx, String qydm, String fjlx);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description
     */
    List<GxYyLcdyPz> getBySqlxAndFjlx(String sqlx, String fjlx);
}

