package cn.gtmap.hlw.core.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/19 16:40
 * @description 领域事件接口，问询笔录
 */
@Data
public class WxbSaveParamsModel {
    /** 问讯笔录主键*/
    private String wxblId;
    /** 受理编号 */
    private String slbh;
    /** 申请类型 */
    private String sqlx;
    /** 权利人类型 */
    private String qlrlx;
    /** 题目编号和答案 格式:{"dm1":"da1","dm2":"da2"} */
    private String dmDa;
    /** 用户Guid*/
    private String userGuid;
    /** 创建时间 */
    private Date createTime;
    /**是否人脸认证（0：是，1：否） */
    private Integer sfrlrz;

    /** 人脸认证时间 */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date rlrzTime;

    /** 人脸认证id(第三方)'; */
    private String rlrzid;
}
