package cn.gtmap.hlw.core.dao.menu;

import cn.gtmap.hlw.core.model.GxYyMenuResourceRel;

import java.util.List;

/**
 * (GxYyMenuResourceRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:34:59
 */
public interface GxYyMenuResourceRelDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyMenuResourceRel get(String id);


    /**
     * 获取数据
     *
     * @param functionMenuId 功能菜单id
     * @return 影响行数
     */
    List<GxYyMenuResourceRel> getGxYyMenuResourceRelByFunctionMenuId(String functionMenuId);

    /**
     * 获取数据
     *
     * @param functionMenuIds 功能菜单id
     * @return 影响行数
     */
    List<GxYyMenuResourceRel> getByFunctionMenuIds(List<String> functionMenuIds);

    /**
     * 保存更新
     *
     * @param gxYyMenuResourceRel
     */
    void saveOrUpdateR(GxYyMenuResourceRel gxYyMenuResourceRel);

    /**
     * 保存更新--批量
     *
     * @param gxYyMenuResourceRels
     */
    void saveOrUpdateBatchR(List<GxYyMenuResourceRel> gxYyMenuResourceRels);

    /**
     * 根据functionMenuId删除
     *
     * @param functionMenuId
     */
    void deleteByFunctionMenuId(String functionMenuId);

    /**
     * @param resourceIdList
     * @description 根据resourceid查询
     * @return:List<GxYyMenuResourceRelPO>
     * @version 2.0, 2024/2/19 14:44
     * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
     */
    List<GxYyMenuResourceRel> listByResourceIds(List<String> resourceIdList);

    /**
     * 批量保存
     *
     * @param menuResourceRelList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatchSomeColumn(List<GxYyMenuResourceRel> menuResourceRelList);

    /**
     * 根据资源id集合删除
     *
     * @param resourceIdList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByResourceIdList(List<String> resourceIdList);

    /**
     * 根据菜单id查询
     *
     * @param functionMenuIdList
     * @return:List<GxYyMenuResourceRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenuResourceRel> listByFunctionMenuIds(List<String> functionMenuIdList);

    /**
     * 根据菜单id删除
     *
     * @param functionMenuIdList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByFunctionMenuIdList(List<String> functionMenuIdList);

    /**
     * 根据菜单id查询
     *
     * @param functionMenuId
     * @return:GxYyFunctionMenuPO
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyMenuResourceRel getByFunctionMenuId(String functionMenuId);
}

