/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class ESignUtils {
    public static String doContentMD5(String str) throws Exception {
        byte[] md5Bytes = null;
        MessageDigest md5 = null;
        String contentMD5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes(StandardCharsets.UTF_8));
            md5Bytes = md5.digest();
            contentMD5 = new String(Base64.encodeBase64((byte[])md5Bytes), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u4e0d\u652f\u6301\u6b64\u7b97\u6cd5");
        }
        return contentMD5;
    }

    public static String doSignatureBase64(String message, String secret) throws Exception {
        String algorithm = "HmacSHA256";
        String digestBase64 = null;
        try {
            Mac hmacSha256 = Mac.getInstance(algorithm);
            byte[] keyBytes = secret.getBytes(StandardCharsets.UTF_8);
            byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, algorithm));
            byte[] digestBytes = hmacSha256.doFinal(messageBytes);
            digestBase64 = new String(Base64.encodeBase64((byte[])digestBytes), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u4e0d\u652f\u6301\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeyException e) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u65e0\u6548\u7684\u5bc6\u94a5\u89c4\u8303");
        }
        return digestBase64;
    }
}

