package cn.gtmap.hlw.coredk.exception;

import lombok.Data;

@Data
public class ExchangeException extends RuntimeException{
    /**
     * 错误代码:返回给前端
     * 客户端需要根据服务端的错误代码进行处理
     */
    private ExchangeError iError;

    /**
     * 需要打印日志的：失败信息描述
     */
    private String message;

    public ExchangeException(String code , String message) {
        ExchangeError iError = new ExchangeError() {
            @Override
            public String getCode() {
                return code;
            }

            @Override
            public String getMsg() {
                return message;
            }
        };
        this.iError = iError;
        this.message = message;
    }

    public ExchangeException(ExchangeError iError) {
        super(iError.getMsg());
        this.iError = iError;
    }

    public ExchangeException(ExchangeError iError, Throwable cause) {
        super(iError.getMsg(), cause);
        this.iError = iError;
    }


    public ExchangeException(ExchangeError iError, String message) {
        super(message);
        this.iError = iError;
        this.message = message;
    }

    public ExchangeException(ExchangeError iError, String message, Throwable cause) {
        super(message, cause);
        this.iError = iError;
        this.message = message;
    }
}
