/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption.md5;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Md5 {
    private static Logger logger = LoggerFactory.getLogger(Md5.class);
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String MD5_SALT = "gtis";

    public static String sign(String text, String key, String inputCharset) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            if (StringUtils.isBlank((CharSequence)inputCharset)) {
                inputCharset = String.valueOf(StandardCharsets.UTF_8);
            }
            if (StringUtils.isNotBlank((CharSequence)key)) {
                text = text + key;
            }
            return DigestUtils.md5Hex((byte[])Md5.getContentBytes(text, inputCharset));
        }
        return null;
    }

    public static String signNoKey(String text, String inputCharset) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            if (StringUtils.isBlank((CharSequence)inputCharset)) {
                inputCharset = String.valueOf(StandardCharsets.UTF_8);
            }
            return DigestUtils.md5Hex((byte[])Md5.getContentBytes(text, inputCharset));
        }
        return null;
    }

    public static boolean verify(String text, String sign, String key, String inputCharset) {
        text = text + key;
        String mysign = DigestUtils.md5Hex((byte[])Md5.getContentBytes(text, inputCharset));
        return mysign.equals(sign);
    }

    private static byte[] getContentBytes(String content, String charset) {
        try {
            if (charset == null || charset.isEmpty()) {
                return content.getBytes(StandardCharsets.UTF_8);
            }
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset, (Throwable)e);
            return null;
        }
    }

    public static String md5Sign(String str) {
        try {
            byte[] strTemp = str.getBytes();
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] tmp = mdTemp.digest();
            char[] strs = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                strs[k++] = HEX_DIGITS[byte0 >>> 4 & 0xF];
                strs[k++] = HEX_DIGITS[byte0 & 0xF];
            }
            return new String(strs).toUpperCase();
        }
        catch (Exception e) {
            return null;
        }
    }
}

