/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.ahwstface;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import com.iflytek.uccp.auth.sdk.util.sm3.SM3Digest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static Logger logger = LoggerFactory.getLogger(SignUtils.class);

    public static String getSign(TreeMap<String, String> params, String appKey) {
        String s = SignUtils.buildSignData(params, appKey);
        return SM3Digest.sm3Encry((String)s);
    }

    private static String buildSignData(TreeMap<String, String> params, String appKey) {
        StringBuilder data = new StringBuilder();
        int[] index = new int[]{0};
        int size = params.size();
        params.forEach((k, v) -> {
            if (StringUtils.isNotBlank((CharSequence)v)) {
                data.append(k + "=" + v);
                if (index[0] != size - 1) {
                    data.append("&");
                }
            }
            index[0] = index[0] + 1;
        });
        try {
            String signDateStr = URLEncoder.encode(data + appKey, "UTF-8");
            logger.debug("\u5f85\u7b7e\u540d\u7684\u5b57\u7b26\u4e32\uff1a{}", (Object)signDateStr);
            return signDateStr;
        }
        catch (UnsupportedEncodingException e) {
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, (Throwable)e);
        }
    }
}

