/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.helium.client.config;

import cn.gtmap.helium.client.config.AbstractWatchedHeliumConfig;
import cn.gtmap.helium.client.core.ConfigProvider;
import cn.gtmap.helium.client.core.DefaultConfigProvider;
import cn.gtmap.helium.client.core.HeliumBean;
import cn.gtmap.helium.client.exception.HeliumConfigException;
import cn.gtmap.helium.client.model.ConfigModel;
import cn.gtmap.helium.client.util.ObjectMapperUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.springframework.util.ResourceUtils;

public class JsonHeliumConfig
extends AbstractWatchedHeliumConfig {
    private ConfigProvider configProvider;

    public JsonHeliumConfig(HeliumBean heliumBean) {
        super(heliumBean);
    }

    protected Properties toProperties(Collection<ConfigModel> ConfigModels) {
        Properties properties = new Properties();
        for (ConfigModel ConfigModel2 : ConfigModels) {
            properties.setProperty(ConfigModel2.getKey(), ConfigModel2.getValue());
        }
        return properties;
    }

    @Override
    protected void doRefresh() {
        HashSet<ConfigModel> ConfigModelSet = new HashSet<ConfigModel>();
        List<HeliumBean.Resource> resources = this.getHeliumBean().getResources();
        for (int i = resources.size() - 1; i >= 0; --i) {
            HeliumBean.Resource resource = resources.get(i);
            try {
                File file = ResourceUtils.getFile((String)resource.getLocation());
                ConfigModel[] ConfigModelArray = ObjectMapperUtils.readValue(file, ConfigModel[].class);
                ConfigModelSet.addAll(Arrays.asList(ConfigModelArray));
                continue;
            }
            catch (Exception e) {
                if (resource.isIgnoreNotFound()) {
                    this.logger.info("\u6587\u4ef6 [{}] \u4e0d\u5b58\u5728, \u5df2\u5ffd\u7565", (Object)resource.getLocation());
                    continue;
                }
                if (e instanceof FileNotFoundException) {
                    throw new HeliumConfigException("\u672a\u53d1\u73b0\u914d\u7f6e\u6587\u4ef6 [" + resource.getLocation() + "]", e);
                }
                throw new HeliumConfigException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6 [" + resource.getLocation() + "] \u9519\u8bef", e);
            }
        }
        this.configProvider = new DefaultConfigProvider(this.toProperties(ConfigModelSet));
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public ConfigProvider getConfigProvider() {
        return this.configProvider;
    }
}

