/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.helium.client.config;

import cn.gtmap.helium.client.core.AbstractHeliumConfig;
import cn.gtmap.helium.client.core.HeliumBean;
import cn.gtmap.helium.client.core.HeliumConfig;
import cn.gtmap.helium.client.exception.HeliumConfigException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public abstract class AbstractWatchedHeliumConfig
extends AbstractHeliumConfig {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private HeliumBean heliumBean;
    private Thread fileWatchThread;

    protected AbstractWatchedHeliumConfig(HeliumBean heliumBean) {
        Assert.notNull((Object)heliumBean);
        this.heliumBean = heliumBean;
    }

    @Override
    protected void doInit() {
        this.refresh();
        this.fileWatchThread = new Thread((Runnable)new ConfigFileWatch(this, this.heliumBean), "heliumconfig-file-watch");
        this.fileWatchThread.setDaemon(true);
        this.fileWatchThread.start();
    }

    protected HeliumBean getHeliumBean() {
        return this.heliumBean;
    }

    private class ConfigFileWatch
    implements Runnable {
        private HeliumConfig heliumConfig;
        private HeliumBean heliumBean;

        private ConfigFileWatch(HeliumConfig heliumConfig, HeliumBean heliumBean) {
            this.heliumConfig = heliumConfig;
            this.heliumBean = heliumBean;
        }

        @Override
        public void run() {
            WatchService watchService;
            try {
                watchService = FileSystems.getDefault().newWatchService();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            ArrayList<String> fileNames = new ArrayList<String>();
            for (HeliumBean.Resource resource : this.heliumBean.getResources()) {
                try {
                    URL url = ResourceUtils.getURL((String)resource.getLocation());
                    if (ResourceUtils.isJarURL((URL)url)) {
                        url = ResourceUtils.extractJarFileURL((URL)url);
                    }
                    Path path = Paths.get(url.toURI());
                    File file = path.toFile();
                    String fileName = file.getName();
                    if (file.isFile() || !file.isFile() && !file.isDirectory()) {
                        file = file.getParentFile();
                        path = path.getParent();
                    }
                    if (path == null || !file.isDirectory()) {
                        AbstractWatchedHeliumConfig.this.logger.warn("\u8df3\u8fc7\u5bf9\u6587\u4ef6 [{}] \u7684\u76d1\u542c, \u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u6587\u4ef6\u5939\u8def\u5f84", (Object)resource.getLocation());
                        continue;
                    }
                    path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                    fileNames.add(fileName);
                }
                catch (FileNotFoundException e) {
                    if (resource.isIgnoreNotFound()) continue;
                    throw new HeliumConfigException(e);
                }
                catch (Exception e) {
                    throw new HeliumConfigException(e);
                }
            }
            while (true) {
                WatchKey watchKey = null;
                try {
                    watchKey = watchService.take();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (watchKey == null) continue;
                List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
                for (WatchEvent<?> watchEvent : watchEvents) {
                    if (!fileNames.contains(watchEvent.context().toString())) continue;
                    this.heliumConfig.refresh();
                    break;
                }
                watchKey.reset();
            }
        }
    }
}

