/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.core.redis;

import cn.gtmap.core.exception.LogQueueConnectException;
import cn.gtmap.core.redis.RedisAbstractClient;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class RedisClusterClient
extends RedisAbstractClient {
    private static RedisClusterClient instance;
    private JedisCluster jedisCluster;
    private static final String script = "local rs=redis.call('setnx',KEYS[1],ARGV[1]);if(rs<1) then return 0;end;redis.call('expire',KEYS[1],tonumber(ARGV[2]));return 1;";
    private int MAX_ACTIVE = 30;
    private int MAX_IDLE = 8;
    private int MAX_WAIT = 1000;
    private boolean TEST_ON_BORROW = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisClusterClient getInstance(String hosts, String pass) {
        if (instance != null) return instance;
        Class<RedisClusterClient> clazz = RedisClusterClient.class;
        synchronized (RedisClusterClient.class) {
            if (instance != null) return instance;
            instance = new RedisClusterClient(hosts, pass);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public RedisClusterClient(String hosts, String pass) {
        String[] clusterHosts = hosts.split(",");
        HashSet<HostAndPort> jedisClusterNodes = new HashSet<HostAndPort>();
        for (String hostAndPort : clusterHosts) {
            String[] hap = hostAndPort.split(":");
            jedisClusterNodes.add(new HostAndPort(hap[0], Integer.parseInt(hap[1])));
        }
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.MAX_ACTIVE);
        config.setMaxIdle(this.MAX_IDLE);
        config.setMaxWaitMillis((long)this.MAX_WAIT);
        config.setTestOnBorrow(this.TEST_ON_BORROW);
        this.jedisCluster = pass != null && !"".equals(pass) ? new JedisCluster(jedisClusterNodes, 200, 200, 1, pass, (GenericObjectPoolConfig)config) : new JedisCluster(jedisClusterNodes, 200, 200, 1, (GenericObjectPoolConfig)config);
    }

    @Override
    public List<String> getMessage(String key, int size) {
        List list = this.jedisCluster.lrange(key, 0L, (long)(size - 1));
        this.jedisCluster.ltrim(key, (long)size, -1L);
        return list;
    }

    @Override
    public void pushMessage(String key, String strings) throws LogQueueConnectException {
        try {
            this.jedisCluster.rpush(key, new String[]{strings});
        }
        catch (Exception e) {
            throw new LogQueueConnectException("redis \u5199\u5165\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public void putMessageList(String key, List<String> list) throws LogQueueConnectException {
        try {
            for (String str : list) {
                this.jedisCluster.rpush(key, new String[]{str});
            }
        }
        catch (Exception e) {
            throw new LogQueueConnectException("redis \u5199\u5165\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public boolean setNx(String key, Integer expire) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        try {
            Long result = (Long)this.jedisCluster.evalsha(this.jedisCluster.scriptLoad(script, "luakey"), Arrays.asList(key), Arrays.asList(key, String.valueOf(expire)));
            if (result == 1L) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean existsKey(String key) {
        return this.jedisCluster.exists(key);
    }

    @Override
    public String getMessage(String key) {
        String obj = this.jedisCluster.lpop(key);
        return obj;
    }

    @Override
    public void set(String key, String value) {
        this.jedisCluster.set(key, value);
    }

    @Override
    public void set(String key, String value, int seconds) {
        this.jedisCluster.set(key, value);
        this.jedisCluster.expire(key, seconds);
    }

    @Override
    public void expireAt(String key, Long time) {
        this.jedisCluster.expireAt(key, time.longValue());
    }

    @Override
    public void expire(String key, int seconds) {
        this.jedisCluster.expire(key, seconds);
    }

    @Override
    public Long incr(String key) {
        Long re = 0L;
        re = this.jedisCluster.incr(key);
        return re;
    }

    @Override
    public Long incrBy(String key, int value) {
        Long re = 0L;
        re = this.jedisCluster.incrBy(key, (long)value);
        return re;
    }

    @Override
    public void hset(String key, Map<String, String> value) {
        this.jedisCluster.hset(key, value);
    }

    @Override
    public void sadd(String key, String value) {
        this.jedisCluster.sadd(key, new String[]{value});
    }

    @Override
    public Set<String> smembers(String key) {
        return this.jedisCluster.smembers(key);
    }

    @Override
    public void del(String key) {
        this.jedisCluster.del(key);
    }

    @Override
    public void hset(String key, String field, String value) {
        this.jedisCluster.hset(key, field, value);
    }

    @Override
    public void hdel(String key, String ... field) {
        this.jedisCluster.hdel(key, field);
    }

    @Override
    public String hget(String key, String field) {
        String value = this.jedisCluster.hget(key, field);
        return value;
    }

    @Override
    public Long llen(String key) {
        Long value = 0L;
        value = this.jedisCluster.llen(key);
        return value;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        Map value = this.jedisCluster.hgetAll(key);
        return value;
    }

    @Override
    public List<String> hmget(String key, String ... field) {
        List value = this.jedisCluster.hmget(key, field);
        return value;
    }

    @Override
    public Long hincrby(String key, String field, int num) {
        Long re = 0L;
        re = this.jedisCluster.hincrBy(key, field, (long)num);
        return re;
    }

    @Override
    public Long hlen(String key) {
        Long re = 0L;
        re = this.jedisCluster.hlen(key);
        return re;
    }

    @Override
    public void publish(String channel, String message) {
        this.jedisCluster.publish(channel, message);
    }
}

