/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.cluster.web.rest;

import cn.gtmap.gtc.gis.cluster.service.intf.ArcgisServerAdminService;
import cn.gtmap.gtc.gis.cluster.service.intf.GisNodeService;
import cn.gtmap.gtc.gis.domain.cluster.ArcgisServiceDetailResponse;
import cn.gtmap.gtc.gis.domain.cluster.ArcgisServicesResponse;
import cn.gtmap.gtc.gis.domain.cluster.GisNode;
import cn.gtmap.gtc.gis.domain.data.search.ResultBean;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/node"})
public class GisNodeController {
    @Autowired
    private GisNodeService gisNodeService;
    @Autowired
    private ArcgisServerAdminService arcgisServerAdminService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/querybyclusterid"})
    public List<GisNode> queryByClusterId(@RequestParam(name="clusterid") String clusterId) {
        return this.gisNodeService.queryByClusterId(clusterId);
    }

    @GetMapping(value={"/querybyid"})
    public GisNode queryById(@RequestParam(name="id") String id) {
        return this.gisNodeService.queryById(id);
    }

    @GetMapping(value={"/querybyname"})
    public GisNode queryByName(@RequestParam(name="name") String name) {
        return this.gisNodeService.queryByName(name);
    }

    @PostMapping(value={"/add"})
    public ResultBean add(@RequestBody GisNode node) {
        ResultBean resultBean = new ResultBean();
        GisNode node1 = this.gisNodeService.queryByName(node.getName());
        if (node1 != null) {
            resultBean.setSuccess(false);
            resultBean.setMessage("\u8282\u70b9\u540d\u79f0\u5df2\u5b58\u5728");
            return resultBean;
        }
        try {
            resultBean.setData((Object)this.gisNodeService.addNode(node).getId());
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u65b0\u8282\u70b9\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage("\u6dfb\u52a0\u65b0\u8282\u70b9\u65f6\u53d1\u751f\u9519\u8bef");
        }
        return resultBean;
    }

    @PostMapping(value={"/update"})
    public ResultBean update(@RequestBody GisNode node) {
        ResultBean resultBean = new ResultBean();
        GisNode node1 = this.gisNodeService.queryByName(node.getName());
        if (node1 != null && !node1.getName().equals(node.getName())) {
            resultBean.setSuccess(false);
            resultBean.setMessage("\u8282\u70b9\u540d\u79f0\u5df2\u5b58\u5728");
            return resultBean;
        }
        try {
            this.gisNodeService.updateNode(node);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u8282\u70b9\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage("\u66f4\u65b0\u8282\u70b9\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef");
        }
        this.arcgisServerAdminService.updateClientCache(node);
        return resultBean;
    }

    @GetMapping(value={"/delete"})
    public ResultBean delete(@RequestParam(name="id") String id) {
        ResultBean resultBean = new ResultBean();
        try {
            this.gisNodeService.deleteNodeById(id);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u8282\u70b9\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage("\u5220\u9664\u8282\u70b9\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef");
        }
        this.arcgisServerAdminService.deleteClientCache(id);
        return resultBean;
    }

    @GetMapping(value={"/services"})
    public ArcgisServicesResponse services(@RequestParam(name="id") String id, @RequestParam(name="folder", required=false, defaultValue="") String folder) {
        ArcgisServicesResponse response = null;
        try {
            response = this.arcgisServerAdminService.getServices(this.gisNodeService.queryById(id), folder);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8282\u70b9\u670d\u52a1\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return response;
    }

    @GetMapping(value={"/service"})
    public ArcgisServiceDetailResponse service(@RequestParam(name="id") String id, @RequestParam(name="folder", required=false, defaultValue="") String folder, @RequestParam(name="serviceName") String serviceName, @RequestParam(name="serviceType") String serviceType) {
        ArcgisServiceDetailResponse response = null;
        try {
            response = this.arcgisServerAdminService.getServerDetail(this.gisNodeService.queryById(id), folder, serviceName, serviceType);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8282\u70b9\u670d\u52a1\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return response;
    }
}

