/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.cluster.web.rest;

import cn.gtmap.gtc.gis.cluster.service.intf.ArcgisServerAdminService;
import cn.gtmap.gtc.gis.cluster.service.intf.GisClusterService;
import cn.gtmap.gtc.gis.cluster.service.intf.GisNodeService;
import cn.gtmap.gtc.gis.domain.cluster.GisCluster;
import cn.gtmap.gtc.gis.domain.data.search.ResultBean;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/cluster"})
public class GisClusterController {
    @Autowired
    private GisClusterService gisClusterService;
    @Autowired
    private GisNodeService gisNodeService;
    @Autowired
    private ArcgisServerAdminService arcgisServerAdminService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/queryall"})
    public List<GisCluster> queryAll() {
        return this.gisClusterService.queryAll();
    }

    @GetMapping(value={"/querybyid"})
    public GisCluster queryById(@RequestParam(name="id") String id) {
        return this.gisClusterService.queryById(id);
    }

    @GetMapping(value={"/querybyname"})
    public GisCluster queryByName(@RequestParam(name="name") String name) {
        return this.gisClusterService.queryByName(name);
    }

    @PostMapping(value={"/add"})
    public ResultBean add(@RequestBody GisCluster cluster) {
        ResultBean resultBean = new ResultBean();
        GisCluster cluster1 = this.gisClusterService.queryByName(cluster.getName());
        if (cluster1 != null) {
            resultBean.setSuccess(false);
            resultBean.setMessage("\u96c6\u7fa4\u540d\u79f0\u5df2\u5b58\u5728");
            return resultBean;
        }
        try {
            resultBean.setData((Object)this.gisClusterService.addCluster(cluster).getId());
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u65b0\u96c6\u7fa4\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage("\u6dfb\u52a0\u65b0\u96c6\u7fa4\u65f6\u53d1\u751f\u9519\u8bef");
        }
        return resultBean;
    }

    @PostMapping(value={"/update"})
    public ResultBean update(@RequestBody GisCluster cluster) {
        ResultBean resultBean = new ResultBean();
        GisCluster cluster1 = this.gisClusterService.queryByName(cluster.getName());
        if (cluster1 != null && !cluster1.getName().equals(cluster.getName())) {
            resultBean.setSuccess(false);
            resultBean.setMessage("\u96c6\u7fa4\u540d\u79f0\u5df2\u5b58\u5728");
            return resultBean;
        }
        try {
            this.gisClusterService.updateCluster(cluster);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u96c6\u7fa4\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage("\u66f4\u65b0\u96c6\u7fa4\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef");
        }
        return resultBean;
    }

    @GetMapping(value={"/delete"})
    public ResultBean delete(@RequestParam(name="id") String id) {
        ResultBean resultBean = new ResultBean();
        List nodes = this.gisNodeService.queryByClusterId(id);
        try {
            this.gisClusterService.deleteClusterById(id);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u96c6\u7fa4\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage("\u5220\u9664\u96c6\u7fa4\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef");
        }
        this.arcgisServerAdminService.deleteClientCache(nodes);
        return resultBean;
    }
}

