/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.cluster.service.impl;

import cn.gtmap.gtc.gis.cluster.dao.GisNodeRepo;
import cn.gtmap.gtc.gis.cluster.service.intf.GisNodeService;
import cn.gtmap.gtc.gis.domain.cluster.GisNode;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true, rollbackFor={Exception.class})
public class GisNodeServiceImpl
implements GisNodeService {
    @Autowired
    private GisNodeRepo gisNodeRepo;

    public List<GisNode> queryByClusterId(String clusterId) {
        return this.gisNodeRepo.findByClusterId(clusterId);
    }

    public GisNode queryById(String id) {
        GisNode gisNode = new GisNode();
        gisNode.setId(id);
        Example ex = Example.of((Object)gisNode);
        return (GisNode)this.gisNodeRepo.findOne(ex).get();
    }

    public GisNode queryByName(String name) {
        return this.gisNodeRepo.findByName(name);
    }

    @Transactional(rollbackFor={Exception.class})
    public GisNode addNode(GisNode gisNode) {
        return (GisNode)this.gisNodeRepo.save((Object)gisNode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateNode(GisNode gisNode) {
        this.gisNodeRepo.save((Object)gisNode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteNodeById(String id) {
        this.gisNodeRepo.deleteByClusterId(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteNodeByClusterId(String clusterId) {
        this.gisNodeRepo.deleteByClusterId(clusterId);
    }
}

