/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.cluster.service.impl;

import cn.gtmap.gtc.gis.cluster.dao.GisClusterRepo;
import cn.gtmap.gtc.gis.cluster.service.intf.GisClusterService;
import cn.gtmap.gtc.gis.cluster.service.intf.GisNodeService;
import cn.gtmap.gtc.gis.domain.cluster.GisCluster;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true, rollbackFor={Exception.class})
public class GisClusterServiceImpl
implements GisClusterService {
    @Autowired
    private GisClusterRepo gisClusterRepo;
    @Autowired
    private GisNodeService gisNodeService;

    public List<GisCluster> queryAll() {
        return this.gisClusterRepo.findAll(new Sort(Sort.Direction.ASC, new String[]{"type"}));
    }

    public GisCluster queryById(String id) {
        GisCluster gisCluster = new GisCluster();
        gisCluster.setId(id);
        Example ex = Example.of((Object)gisCluster);
        return (GisCluster)this.gisClusterRepo.findOne(ex).get();
    }

    @Transactional(rollbackFor={Exception.class})
    public GisCluster addCluster(GisCluster gisCluster) {
        return (GisCluster)this.gisClusterRepo.save((Object)gisCluster);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCluster(GisCluster gisCluster) {
        this.gisClusterRepo.save((Object)gisCluster);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteClusterById(String id) {
        this.gisNodeService.deleteNodeByClusterId(id);
        this.gisClusterRepo.deleteById(id);
    }

    public GisCluster queryByName(String name) {
        return this.gisClusterRepo.findByName(name);
    }
}

