/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.cluster.service.impl;

import cn.gtmap.gtc.gis.cluster.arcgis.ArcgisServerAdminClient;
import cn.gtmap.gtc.gis.cluster.config.ArcgisNodeConfig;
import cn.gtmap.gtc.gis.cluster.service.intf.ArcgisServerAdminService;
import cn.gtmap.gtc.gis.domain.cluster.ArcgisServiceDetailResponse;
import cn.gtmap.gtc.gis.domain.cluster.ArcgisServicesResponse;
import cn.gtmap.gtc.gis.domain.cluster.GisNode;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ArcgisServerAdminServiceImpl
implements ArcgisServerAdminService {
    @Autowired
    private ArcgisNodeConfig arcgisNodeConfig;
    @Autowired
    private RestTemplate restTemplate;
    private ConcurrentMap<String, ArcgisServerAdminClient> clients = new ConcurrentHashMap();

    public int getServerStatus(GisNode gisNode) {
        if (gisNode == null) {
            return 0;
        }
        ArcgisServerAdminClient client = (ArcgisServerAdminClient)this.clients.get(gisNode.getId());
        if (client != null && gisNode.getUrl() != null && gisNode.getUrl().equals(client.getBaseUrl())) {
            return client.getServerStatus();
        }
        client = new ArcgisServerAdminClient(gisNode, this.arcgisNodeConfig.getExpiration(), this.restTemplate);
        this.clients.put(gisNode.getId(), client);
        return client.getServerStatus();
    }

    public ArcgisServicesResponse getServices(GisNode gisNode, String folder) {
        if (gisNode == null) {
            return null;
        }
        ArcgisServerAdminClient client = (ArcgisServerAdminClient)this.clients.get(gisNode.getId());
        if (client != null && gisNode.getUrl() != null && gisNode.getUrl().equals(client.getBaseUrl())) {
            return client.getServices(folder);
        }
        client = new ArcgisServerAdminClient(gisNode, this.arcgisNodeConfig.getExpiration(), this.restTemplate);
        this.clients.put(gisNode.getId(), client);
        return client.getServices(folder);
    }

    public void deleteClientCache(List<GisNode> nodeList) {
        if (nodeList != null && !nodeList.isEmpty()) {
            for (GisNode node : nodeList) {
                this.clients.remove(node.getId());
            }
        }
    }

    public void deleteClientCache(String id) {
        this.clients.remove(id);
    }

    public ArcgisServiceDetailResponse getServerDetail(GisNode gisNode, String folder, String serviceName, String serviceType) {
        if (gisNode == null) {
            return null;
        }
        ArcgisServerAdminClient client = (ArcgisServerAdminClient)this.clients.get(gisNode.getId());
        if (client != null && gisNode.getUrl() != null && gisNode.getUrl().equals(client.getBaseUrl())) {
            return client.getServiceDetail(folder, serviceName, serviceType);
        }
        client = new ArcgisServerAdminClient(gisNode, this.arcgisNodeConfig.getExpiration(), this.restTemplate);
        this.clients.put(gisNode.getId(), client);
        return client.getServiceDetail(folder, serviceName, serviceType);
    }

    public void updateClientCache(GisNode gisNode) {
        if (gisNode == null || this.clients.containsKey(gisNode.getId()) && gisNode.getUrl().equals(((ArcgisServerAdminClient)this.clients.get(gisNode.getId())).getBaseUrl())) {
            return;
        }
        ArcgisServerAdminClient client = new ArcgisServerAdminClient(gisNode, this.arcgisNodeConfig.getExpiration(), this.restTemplate);
        this.clients.put(gisNode.getId(), client);
    }
}

