/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.gis.cluster.arcgis;

import cn.gtmap.gtc.gis.cluster.arcgis.GenerateTokenResponse;
import cn.gtmap.gtc.gis.domain.cluster.ArcgisServiceDetailResponse;
import cn.gtmap.gtc.gis.domain.cluster.ArcgisServicesResponse;
import cn.gtmap.gtc.gis.domain.cluster.GisNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ArcgisServerAdminClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String baseUrl;
    private String user;
    private String password;
    private int expiration;
    private long localLogInTime;
    private RestTemplate restTemplate;
    private String token;
    private ObjectMapper mapper;
    private static final String TOKEN_NAME = "token";
    private static final int MINUTE_TO_MILLISECOND = 60000;
    private int status = 0;

    public ArcgisServerAdminClient(String url, String user, String password, int expiration, RestTemplate restTemplate) {
        this.baseUrl = url;
        this.user = user;
        this.password = password;
        this.expiration = expiration;
        this.restTemplate = restTemplate;
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.login();
    }

    public ArcgisServerAdminClient(GisNode gisNode, int expiration, RestTemplate restTemplate) {
        this.baseUrl = gisNode.getUrl();
        this.user = gisNode.getNode_user();
        this.password = gisNode.getPassword();
        this.expiration = expiration;
        this.restTemplate = restTemplate;
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.login();
    }

    private void login() {
        this.status = 0;
        this.token = "";
        if (StringUtils.isEmpty((String)this.baseUrl)) {
            return;
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"username", (Object)this.user);
        params.add((Object)"password", (Object)this.password);
        params.add((Object)"client", (Object)"requestip");
        params.add((Object)"expiration", (Object)String.valueOf(this.expiration));
        params.add((Object)"f", (Object)"json");
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            String res = (String)this.restTemplate.postForObject(this.baseUrl + (this.baseUrl.endsWith("/") ? "" : "/") + "generateToken", (Object)httpEntity, String.class, new Object[0]);
            GenerateTokenResponse response = (GenerateTokenResponse)this.mapper.readValue(res, GenerateTokenResponse.class);
            this.token = response.getToken();
            this.status = 1;
            this.localLogInTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6arcgis server\u7684token\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void checkExpiredAndLogin() {
        long currentTime = System.currentTimeMillis();
        if (StringUtils.isEmpty((String)this.token) || (currentTime - this.localLogInTime) / 60000L > (long)this.expiration) {
            this.login();
        }
    }

    public int getServerStatus() {
        this.checkExpiredAndLogin();
        if (StringUtils.isEmpty((String)this.token)) {
            return 0;
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"f", (Object)"json");
        params.add((Object)TOKEN_NAME, (Object)this.token);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            String url = this.baseUrl + (this.baseUrl.endsWith("/") ? "" : "/") + "info";
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                this.status = 1;
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u770barcgis server\u7684\u8fd0\u884c\u72b6\u6001\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return this.status;
    }

    public String getToken() {
        return this.token;
    }

    public ArcgisServicesResponse getServices(String folder) {
        this.checkExpiredAndLogin();
        if (StringUtils.isEmpty((String)this.token)) {
            return null;
        }
        ArcgisServicesResponse response = null;
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"f", (Object)"json");
        params.add((Object)TOKEN_NAME, (Object)this.token);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            String url = this.baseUrl + (this.baseUrl.endsWith("/") ? "" : "/") + "services" + (StringUtils.isEmpty((String)folder) ? "" : "/" + folder);
            String res = (String)this.restTemplate.postForObject(url, (Object)httpEntity, String.class, new Object[0]);
            response = (ArcgisServicesResponse)this.mapper.readValue(res, ArcgisServicesResponse.class);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6arcgis server\u7684services\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return response;
    }

    public ArcgisServiceDetailResponse getServiceDetail(String folder, String serviceName, String serviceType) {
        this.checkExpiredAndLogin();
        if (StringUtils.isEmpty((String)this.token)) {
            return null;
        }
        ArcgisServiceDetailResponse response = null;
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"f", (Object)"json");
        params.add((Object)TOKEN_NAME, (Object)this.token);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            String res = (String)this.restTemplate.postForObject(this.baseUrl + (this.baseUrl.endsWith("/") ? "" : "/") + "services/" + (StringUtils.isEmpty((String)folder) ? "" : folder + "/") + serviceName + "." + serviceType, (Object)httpEntity, String.class, new Object[0]);
            response = (ArcgisServiceDetailResponse)this.mapper.readValue(res, ArcgisServiceDetailResponse.class);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6arcgis server\u7684services\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return response;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

