<html xmlns:th="http://www.thymeleaf.org">
<body>

<div>
    <form id="uploadForm" method="POST" enctype="multipart/form-data" action="/rest/storage/upload">
        <input type="file" name="file" multiple="multiple"/>
        <input type="submit" value="表格提交"/>
    </form>
    <button onclick="upload()">异步提交</button>
    <div id="result">

    </div>
</div>

<script type="text/javascript">

    function upload() {
        var formData = new FormData(document.getElementById('uploadForm'));

        var xhr = new XMLHttpRequest();
        xhr.open('POST', '/rest/storage/upload', true);

        xhr.upload.addEventListener('progress', function onprogressHandler(evt) {
            var percent = evt.loaded / evt.total * 100;
            console.log('Upload progress: ' + percent + '%');
        }, false);
        xhr.onload = function (evt) {
            document.getElementById('result').innerHTML = "";
            var ids = JSON.parse(evt.currentTarget.responseText);
            for (var i = 0; i < ids.length; i++) {
                var a = document.createElement('a');
                a.href = "/rest/storage/download/" + ids[i].id;
                a.innerHTML = a.href;
                a.target = "_Blank";
                document.getElementById('result').appendChild(a);
            }
        };

        xhr.send(formData);
    }


</script>

</body>
</html>