/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.storage.web.rest;

import cn.gtmap.gtcc.domain.storage.Storage;
import cn.gtmap.gtcc.storage.config.StorageProperties;
import cn.gtmap.gtcc.storage.service.OSSService;
import cn.gtmap.gtcc.storage.service.StorageService;
import cn.gtmap.gtcc.storage.service.ThumbnailService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/multipart/storage"})
public class StorageMultipartController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int CACHE_MAX_AGE = 86400;
    @Autowired
    StorageService storageService;
    @Autowired
    ThumbnailService thumbnailService;
    @Autowired
    private OSSService ossService;
    private final String storageType;
    private final String appOssEndpoint;
    private final String appOssAccessKeyId;
    private final String appOssAccessKeySecret;
    private final String egovType;
    private final String ossType;
    private final String transformUrl;
    private final String storageUrl;

    public StorageMultipartController(StorageProperties storageProperties) {
        this.storageType = storageProperties.getStorageType();
        this.appOssEndpoint = storageProperties.getAppOssEndpoint();
        this.appOssAccessKeyId = storageProperties.getAppOssAccessKeyId();
        this.appOssAccessKeySecret = storageProperties.getAppOssAccessKeySecret();
        this.egovType = storageProperties.getEgovType();
        this.ossType = storageProperties.getOssType();
        this.transformUrl = storageProperties.getTransformUrl();
        this.storageUrl = storageProperties.getStorageUrl();
    }

    @CrossOrigin
    @PostMapping(value={"/upload"})
    @ResponseBody
    public Storage[] multipartUpload(@RequestParam(value="file") MultipartFile[] files) {
        Storage[] storages = null;
        storages = StringUtils.equals((String)this.storageType, (String)this.ossType) ? this.ossService.store(files) : this.storageService.store(files);
        return storages;
    }
}

