/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.storage.web.rest;

import cn.gtmap.gtcc.domain.storage.Node;
import cn.gtmap.gtcc.domain.storage.NodeQuery;
import cn.gtmap.gtcc.domain.storage.Storage;
import cn.gtmap.gtcc.storage.service.NodeService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/node"})
public class NodeController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    NodeService nodeService;

    @CrossOrigin
    @RequestMapping(value={"/{id}"})
    public Node getNodeById(@PathVariable(value="id") String Id) {
        Node nodeList = this.nodeService.getNodeById(Id);
        return nodeList;
    }

    @CrossOrigin
    @RequestMapping(value={"/owner/{owner}"})
    @ResponseBody
    public List<Node> getNodeListByOwner(@PathVariable(value="owner") String owner) {
        List<Node> nodeList = null;
        return nodeList;
    }

    @CrossOrigin
    @RequestMapping(value={"/storages/json/get"})
    @ResponseBody
    public Set<Storage> getNodeListByJson(NodeQuery query) {
        List nodeList = this.nodeService.getNodeListByJson(query);
        HashSet<Storage> storages = new HashSet<Storage>();
        if (CollectionUtils.isNotEmpty((Collection)nodeList)) {
            for (Node node : nodeList) {
                storages.addAll(node.getStorages());
            }
        }
        return storages;
    }
}

