/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.storage.service.impl;

import cn.gtmap.gtcc.domain.storage.Storage;
import cn.gtmap.gtcc.ex.StorageException;
import cn.gtmap.gtcc.ex.StorageFileNotFoundException;
import cn.gtmap.gtcc.storage.config.StorageProperties;
import cn.gtmap.gtcc.storage.dao.StorageRepo;
import cn.gtmap.gtcc.storage.service.StorageService;
import cn.gtmap.gtcc.storage.utils.CommonUtil;
import cn.gtmap.gtcc.utils.UUIDGenerator;
import cn.gtmap.gtcc.utils.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class StorageServiceImpl<S extends Storage>
implements StorageService<S> {
    private final Path location;
    private final String ossType;
    @Autowired
    private StorageRepo storeRepo;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public StorageServiceImpl(StorageProperties storageProperties) {
        this.location = Paths.get(storageProperties.getLocaltion(), new String[0]);
        this.ossType = storageProperties.getOssType();
    }

    public S store(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            throw new StorageException("failed to store empty file");
        }
        try {
            return (S)((Storage)this.storeRepo.save((Object)this.createStorage(file, this.saveFile(file))));
        }
        catch (IOException e) {
            throw new StorageException("failed to store file " + file.getOriginalFilename());
        }
    }

    public Storage[] store(MultipartFile[] files) {
        Storage[] sto = new Storage[files.length];
        for (int i = 0; i < files.length; ++i) {
            sto[i] = this.store(files[i]);
        }
        return sto;
    }

    public Storage createStorage(MultipartFile file) {
        Assert.notNull((Object)file, (String)"file can't be null");
        Storage storage = new Storage();
        return storage.setName(file.getOriginalFilename()).setFileType(file.getContentType()).setPath(this.ossType).setFileSize(file.getSize());
    }

    private Path saveFile(MultipartFile file) throws IOException {
        Path loc;
        block3: {
            try {
                loc = this.location.resolve(file.getOriginalFilename());
                if (Files.exists(loc, new LinkOption[0])) {
                    loc = this.location.resolve(file.getOriginalFilename() + "_" + Math.random());
                }
            }
            catch (Exception e) {
                String name = CommonUtil.decodeBase64((String)file.getOriginalFilename());
                loc = this.location.resolve(name);
                if (!Files.exists(loc, new LinkOption[0])) break block3;
                loc = this.location.resolve(name + "_" + Math.random());
            }
        }
        Files.copy(file.getInputStream(), loc, new CopyOption[0]);
        return loc;
    }

    private Storage createStorage(MultipartFile file, Path location) {
        Assert.notNull((Object)file, (String)"file can't be null");
        Storage storage = new Storage();
        return storage.setName(file.getOriginalFilename()).setFileType(file.getContentType()).setPath(location.toAbsolutePath().toString()).setFileSize(file.getSize());
    }

    private Storage createStorage(Map param, Path location) {
        Assert.notNull((Object)param, (String)"file can't be null");
        Storage storage = new Storage();
        MultipartFile file = (MultipartFile)MapUtils.getObject((Map)param, (Object)"file", null);
        String type = MapUtils.getString((Map)param, (Object)"type", null);
        String id = MapUtils.getString((Map)param, (Object)"id", null);
        Storage storage1 = this.storeRepo.findById(id);
        return storage.setName(CommonUtil.decodeBase64((String)file.getOriginalFilename())).setFileType(type).setPath(location.toAbsolutePath().toString()).setFileSize(file.getSize()).setParent(storage1);
    }

    public Storage createStorage(Map param) {
        Storage storage = new Storage();
        MultipartFile file = (MultipartFile)MapUtils.getObject((Map)param, (Object)"file", null);
        String type = MapUtils.getString((Map)param, (Object)"type", null);
        String id = MapUtils.getString((Map)param, (Object)"id", null);
        Storage storage1 = this.storeRepo.findById(id);
        return storage.setName(CommonUtil.decodeBase64((String)file.getOriginalFilename())).setFileType(type).setPath(this.ossType).setFileSize(file.getSize()).setParent(storage1);
    }

    public Set<Storage> findByName(String name) {
        return this.storeRepo.findByNameContaining(name);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<S> findChildren(String id) {
        Optional storage = this.load(id);
        if (storage.isPresent()) {
            return ((Storage)storage.get()).getChildren();
        }
        return new ArrayList();
    }

    public Page<S> search(String name, Pageable pageable) {
        return this.storeRepo.findByNameContaining(name, pageable);
    }

    public Set<S> findByIds(String ... ids) {
        return this.storeRepo.findByIdIn(new HashSet<String>(Arrays.asList(ids)));
    }

    public Optional<S> load(String id) {
        Storage s = (Storage)this.storeRepo.findOne((Serializable)((Object)id));
        if (s == null) {
            throw new StorageFileNotFoundException(id);
        }
        return Optional.of(s);
    }

    public boolean delete(String id) {
        try {
            this.storeRepo.delete((Serializable)((Object)id));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Storage[] store(List<Map> param) {
        try {
            if (CollectionUtils.isNotEmpty(param)) {
                List<Storage> list = param.stream().map(map -> {
                    MultipartFile file = (MultipartFile)MapUtils.getObject((Map)map, (Object)"file", null);
                    try {
                        return (Storage)this.storeRepo.save((Object)this.createStorage(map, this.saveFile(file)));
                    }
                    catch (Exception e) {
                        throw new StorageException("failed to store file " + file.getOriginalFilename());
                    }
                }).collect(Collectors.toList());
                return list.toArray(new Storage[list.size()]);
            }
            throw new StorageException("failed to store empty file");
        }
        catch (Exception e) {
            throw new StorageException("failed to store empty file");
        }
    }

    public S findById(String id) {
        return (S)this.storeRepo.findById(id);
    }

    @PostConstruct
    private void init() {
        if (!Files.exists(this.location, new LinkOption[0])) {
            try {
                Files.createDirectories(this.location, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new StorageException("can't init storage location " + this.location.toString());
            }
        }
    }

    public Storage zipStorage(String[] ids, String name) {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String id : ids) {
            File file;
            Storage storage = this.findById(id);
            if (storage == null || !(file = new File(storage.getPath())).exists()) continue;
            files.add(file);
            fileNames.add(storage.getName());
        }
        String zipName = "";
        zipName = StringUtils.isEmpty((Object)name) ? UUIDGenerator.generate() + ".zip" : (name.toLowerCase().endsWith(".zip") ? name : name + ".zip");
        Path path = this.location.resolve(zipName);
        String zipPath = path.toAbsolutePath().toString();
        if (Files.exists(path, new LinkOption[0])) {
            zipPath = zipPath.substring(0, zipPath.length() - 4) + "_" + UUIDGenerator.generate() + ".zip";
        }
        ZipUtil.zipFile((String)zipPath, files, fileNames);
        Storage storage = new Storage();
        File zipFile = new File(zipPath);
        if (!zipFile.exists() || !zipFile.isFile()) {
            return null;
        }
        storage.setName(zipName).setFileType("application/zip").setPath(zipPath).setFileSize(zipFile.length());
        return (Storage)this.storeRepo.save((Object)storage);
    }
}

