/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.storage.service.impl;

import cn.gtmap.gtcc.domain.storage.Storage;
import cn.gtmap.gtcc.ex.StorageException;
import cn.gtmap.gtcc.storage.config.StorageProperties;
import cn.gtmap.gtcc.storage.dao.StorageRepo;
import cn.gtmap.gtcc.storage.service.OSSService;
import cn.gtmap.gtcc.storage.service.StorageService;
import cn.gtmap.gtcc.utils.FileUtil;
import cn.gtmap.gtcc.utils.UUIDGenerator;
import cn.gtmap.gtcc.utils.ZipUtil;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OSSServiceImpl
implements OSSService {
    @Autowired
    private StorageService storageService;
    @Autowired
    private StorageRepo storeRepo;
    private final String appOssEndpoint;
    private final String appOssAccessKeyId;
    private final String appOssAccessKeySecret;
    private final String egovType;
    private final String ossType;
    private final String ossBucket;
    private final Path location;

    public OSSServiceImpl(StorageProperties storageProperties) {
        this.appOssEndpoint = storageProperties.getAppOssEndpoint();
        this.appOssAccessKeyId = storageProperties.getAppOssAccessKeyId();
        this.appOssAccessKeySecret = storageProperties.getAppOssAccessKeySecret();
        this.egovType = storageProperties.getEgovType();
        this.ossType = storageProperties.getOssType();
        this.ossBucket = storageProperties.getOssBucket();
        this.location = Paths.get(storageProperties.getLocaltion(), new String[0]);
    }

    @Transactional
    public Storage[] store(MultipartFile[] files) {
        Storage[] storage = new Storage[files.length];
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            OSSClient ossClient = new OSSClient(this.appOssEndpoint, this.appOssAccessKeyId, this.appOssAccessKeySecret);
            InputStream inputStream = null;
            for (int i = 0; i < files.length; ++i) {
                try {
                    inputStream = files[i].getInputStream();
                }
                catch (Exception e) {
                    throw new StorageException("failed to store file " + files[i].getOriginalFilename());
                }
                Storage s = this.storageService.createStorage(files[i]);
                storage[i] = (Storage)this.storeRepo.save((Object)s);
                ossClient.putObject(this.ossBucket, storage[i].getId(), inputStream);
            }
            ossClient.shutdown();
        }
        return storage;
    }

    public byte[] downLoad(String id) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)id)) {
            OSSClient ossClient = new OSSClient(this.appOssEndpoint, this.appOssAccessKeyId, this.appOssAccessKeySecret);
            try {
                OSSObject ossObject = ossClient.getObject(this.ossBucket, id);
                byte[] buffer = new byte[1024];
                int len = -1;
                while ((len = ossObject.getObjectContent().read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                outStream.close();
                ossObject.getObjectContent().close();
            }
            catch (Exception e) {
                throw new StorageException("failed to store file ");
            }
            finally {
                ossClient.shutdown();
            }
            return outStream.toByteArray();
        }
        return null;
    }

    public Storage[] store(List<Map> param) {
        OSSClient ossClient = new OSSClient(this.appOssEndpoint, this.appOssAccessKeyId, this.appOssAccessKeySecret);
        List<Object> list = new ArrayList();
        try {
            if (!CollectionUtils.isNotEmpty(param)) {
                throw new StorageException("failed to store empty file");
            }
            list = param.stream().map(map -> {
                MultipartFile file = (MultipartFile)MapUtils.getObject((Map)map, (Object)"file", null);
                InputStream inputStream = null;
                try {
                    inputStream = file.getInputStream();
                    Storage storage = (Storage)this.storeRepo.save((Object)this.storageService.createStorage(map));
                    ossClient.putObject(this.ossBucket, storage.getId(), inputStream);
                    return storage;
                }
                catch (Exception e) {
                    throw new StorageException("failed to store file " + file.getOriginalFilename());
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new StorageException("failed to store empty file");
        }
        ossClient.shutdown();
        return list.toArray(new Storage[list.size()]);
    }

    public Storage zipStorage(String[] ids, String name) {
        Storage storage;
        String folderPath = this.location.toAbsolutePath().toString() + UUIDGenerator.generate();
        File path = new File(folderPath);
        if (!path.exists()) {
            path.mkdirs();
        }
        for (String id : ids) {
            byte[] bytes;
            storage = this.storeRepo.findById(id);
            if (storage == null || (bytes = this.downLoad(id)).length <= 0) continue;
            FileUtil.byte2File((byte[])bytes, (String)folderPath, (String)storage.getName());
        }
        String zipName = "";
        zipName = StringUtils.isEmpty((Object)name) ? UUIDGenerator.generate() + ".zip" : (name.toLowerCase().endsWith(".zip") ? name : name + ".zip");
        File[] files = path.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        String zipPath = folderPath + File.separator + zipName;
        ZipUtil.zipFile((String)zipPath, (File[])files);
        File zipFile = new File(zipPath);
        if (!zipFile.exists()) {
            return null;
        }
        storage = new Storage();
        storage.setName(zipName).setFileType("application/zip").setPath(zipPath).setFileSize(zipFile.length());
        OSSClient ossClient = new OSSClient(this.appOssEndpoint, this.appOssAccessKeyId, this.appOssAccessKeySecret);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(zipFile);
            storage = (Storage)this.storeRepo.save((Object)storage);
            ossClient.putObject(this.ossBucket, storage.getId(), (InputStream)inputStream);
            Storage storage2 = storage;
            return storage2;
        }
        catch (Exception e) {
            throw new StorageException("failed to store file " + zipName);
        }
        finally {
            FileUtil.deleteDir((File)path);
        }
    }
}

