/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.storage.service.impl;

import cn.gtmap.gtcc.domain.storage.Node;
import cn.gtmap.gtcc.domain.storage.NodeQuery;
import cn.gtmap.gtcc.storage.dao.NodeRepo;
import cn.gtmap.gtcc.storage.service.NodeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeServiceImpl
implements NodeService {
    @Autowired
    private NodeRepo nodeRepo;

    public Node getNodeById(String Id) {
        return (Node)this.nodeRepo.findOne((Serializable)((Object)Id));
    }

    public List<Node> getNodeListByJson(NodeQuery query) {
        Node node = null;
        ArrayList<Node> childList = new ArrayList<Node>();
        if (StringUtils.isNotBlank((String)query.getId())) {
            node = (Node)this.nodeRepo.findOne((Serializable)((Object)query.getId()));
        } else if (StringUtils.isNotBlank((String)query.getOwner())) {
            node = this.nodeRepo.findByOwner(query.getOwner());
        }
        List jsonArray = query.getChildren();
        List children = node.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children) && CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            childList.addAll(this.getNodeListByJsonArray(children, jsonArray));
        } else if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            childList.add(node);
        }
        return childList;
    }

    public List<Node> getNodeListByJsonArray(List<Node> nodeList, List<NodeQuery> jsonArray) {
        ArrayList<Node> childList = new ArrayList<Node>();
        for (Node node : nodeList) {
            List children = node.getChildren();
            for (NodeQuery jsonObject : jsonArray) {
                List childArray = jsonObject.getChildren();
                if (StringUtils.isNotBlank((String)jsonObject.getId()) && StringUtils.equals((String)node.getId(), (String)jsonObject.getId())) {
                    if (CollectionUtils.isNotEmpty((Collection)children) && CollectionUtils.isNotEmpty((Collection)childArray)) {
                        childList.addAll(this.getNodeListByJsonArray(children, childArray));
                        continue;
                    }
                    if (!CollectionUtils.isEmpty((Collection)childArray)) continue;
                    childList.add(node);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)jsonObject.getOwner()) || !StringUtils.equals((String)node.getOwner(), (String)jsonObject.getOwner())) continue;
                if (CollectionUtils.isNotEmpty((Collection)children) && CollectionUtils.isNotEmpty((Collection)childArray)) {
                    childList.addAll(this.getNodeListByJsonArray(children, childArray));
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)childArray)) continue;
                childList.add(node);
            }
        }
        return childList;
    }
}

