/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.storage.web.rest;

import cn.gtmap.gtcc.domain.storage.Storage;
import cn.gtmap.gtcc.domain.storage.Thumbnail;
import cn.gtmap.gtcc.ex.StorageFileNotFoundException;
import cn.gtmap.gtcc.storage.config.StorageProperties;
import cn.gtmap.gtcc.storage.service.OSSService;
import cn.gtmap.gtcc.storage.service.StorageService;
import cn.gtmap.gtcc.storage.service.ThumbnailService;
import cn.gtmap.gtcc.storage.utils.CommonUtil;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.UrlResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/storage"})
public class StorageController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int CACHE_MAX_AGE = 86400;
    @Autowired
    StorageService storageService;
    @Autowired
    ThumbnailService thumbnailService;
    @Autowired
    private OSSService ossService;
    private final String storageType;
    private final String appOssEndpoint;
    private final String appOssAccessKeyId;
    private final String appOssAccessKeySecret;
    private final String egovType;
    private final String ossType;
    private final String transformUrl;
    private final String storageUrl;

    public StorageController(StorageProperties storageProperties) {
        this.storageType = storageProperties.getStorageType();
        this.appOssEndpoint = storageProperties.getAppOssEndpoint();
        this.appOssAccessKeyId = storageProperties.getAppOssAccessKeyId();
        this.appOssAccessKeySecret = storageProperties.getAppOssAccessKeySecret();
        this.egovType = storageProperties.getEgovType();
        this.ossType = storageProperties.getOssType();
        this.transformUrl = storageProperties.getTransformUrl();
        this.storageUrl = storageProperties.getStorageUrl();
    }

    @GetMapping(value={"/upload"})
    public String uploadForm() {
        return "upload";
    }

    @CrossOrigin
    @RequestMapping(value={"/upload"})
    @ResponseBody
    public Storage[] upload(@RequestParam(value="file") MultipartFile[] files) {
        Storage[] storages = null;
        storages = StringUtils.equals((String)this.storageType, (String)this.ossType) ? this.ossService.store(files) : this.storageService.store(files);
        return storages;
    }

    @CrossOrigin
    @RequestMapping(value={"/zip"})
    @ResponseBody
    public Storage zip(@RequestParam(value="ids") String ids, @RequestParam(value="name", required=false) String name) {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        if (StringUtils.equals((String)this.storageType, (String)this.ossType)) {
            return this.ossService.zipStorage(ids.split(","), name);
        }
        return this.storageService.zipStorage(ids.split(","), name);
    }

    @CrossOrigin
    @PostMapping(value={"/multipart/upload"})
    @ResponseBody
    public Storage[] multipartUpload(@RequestParam(value="file") MultipartFile[] files) {
        Storage[] storages = null;
        storages = StringUtils.equals((String)this.storageType, (String)this.ossType) ? this.ossService.store(files) : this.storageService.store(files);
        return storages;
    }

    @CrossOrigin
    @RequestMapping(value={"/transform/callback"})
    @ResponseBody
    public Storage[] transformUpload(String id, String filename, String log, @RequestParam(value="filehtml") MultipartFile[] filehtml, @RequestParam(value="fileocrpdf") MultipartFile[] fileocrpdf, @RequestParam(value="filetxt") MultipartFile[] filetxt) {
        this.logger.debug(log);
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(filehtml).stream().map(file -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("file", file);
            map.put("type", "text/html");
            map.put("id", id);
            return map;
        }).collect(Collectors.toList()));
        list.addAll(Arrays.asList(fileocrpdf).stream().map(file -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("file", file);
            map.put("type", "application/pdf");
            map.put("id", id);
            return map;
        }).collect(Collectors.toList()));
        list.addAll(Arrays.asList(filetxt).stream().map(file -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("file", file);
            map.put("type", "text/plain");
            map.put("id", id);
            return map;
        }).collect(Collectors.toList()));
        Storage[] storages = null;
        storages = StringUtils.equals((String)this.storageType, (String)this.ossType) ? this.ossService.store(list) : this.storageService.store(list);
        return storages;
    }

    @CrossOrigin
    @GetMapping(value={"/download/{id}"})
    public ResponseEntity download(@PathVariable String id, @RequestHeader(value="If-Modified-Since", required=false) Date ifModified) {
        Optional storage = this.storageService.load(id);
        if (storage.isPresent()) {
            Storage s = (Storage)storage.get();
            try {
                if (StringUtils.equals((String)s.getPath(), (String)this.ossType)) {
                    byte[] buff = this.ossService.downLoad(id);
                    return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"filename=\"" + URLEncoder.encode(s.getName(), "UTF-8") + "\""})).lastModified(s.getCreateAt().getTime())).contentLength(s.getFileSize()).contentType(MediaType.parseMediaType((String)s.getFileType())).body((Object)buff);
                }
                if (this.checkModified(s.getCreateAt(), ifModified)) {
                    return ResponseEntity.status((HttpStatus)HttpStatus.NOT_MODIFIED).build();
                }
                UrlResource resource = new UrlResource(Paths.get(s.getPath(), new String[0]).toUri());
                if (resource.exists() && resource.isReadable()) {
                    return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"filename=\"" + URLEncoder.encode(s.getName(), "UTF-8") + "\""})).lastModified(s.getCreateAt().getTime())).contentLength(s.getFileSize()).contentType(MediaType.parseMediaType((String)s.getFileType())).body((Object)resource);
                }
                this.logger.info("can't find storage file [{}]", (Object)resource.getFilename());
                return ResponseEntity.noContent().build();
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage());
            }
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/thumbnail/{id}"})
    public ResponseEntity thumbnail(@PathVariable String id, @RequestParam(required=false, defaultValue="-1") int w, @RequestParam(required=false, defaultValue="-1") int h, @RequestHeader(value="If-Modified-Since", required=false) Date ifModified) {
        block7: {
            Optional thumbnail = this.thumbnailService.getThumbnail(id, w, h);
            if (!thumbnail.isPresent()) break block7;
            Thumbnail t = (Thumbnail)thumbnail.get();
            if (this.checkModified(t.getCreateAt(), ifModified)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_MODIFIED).build();
            }
            try {
                UrlResource resource = new UrlResource(Paths.get(t.getPath(), new String[0]).toUri());
                if (resource.exists() && resource.isReadable()) {
                    return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"filename=\"" + URLEncoder.encode(t.getThumbnailName(), "UTF-8") + "\""})).lastModified(t.getCreateAt().getTime())).cacheControl(CacheControl.maxAge((long)86400L, (TimeUnit)TimeUnit.SECONDS))).contentLength(t.getFileSize()).contentType(MediaType.IMAGE_PNG).body((Object)resource);
                }
                this.logger.info("can't find storage file [{}]", (Object)resource.getFilename());
                return ResponseEntity.noContent().build();
            }
            catch (Exception e) {
                try {
                    this.logger.error(e.getLocalizedMessage());
                }
                catch (Exception e2) {
                    ResponseEntity.badRequest().body((Object)e2.getLocalizedMessage());
                }
            }
        }
        return ResponseEntity.notFound().build();
    }

    private boolean checkModified(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        if (d1 instanceof Timestamp) {
            long t = d1.getTime() - (long)(((Timestamp)d1).getNanos() / 1000000);
            return t == d2.getTime();
        }
        return d1.equals(d2);
    }

    @ExceptionHandler(value={StorageFileNotFoundException.class})
    public ResponseEntity handleStorageFileNotFound(StorageFileNotFoundException exc) {
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/transform/{id}"})
    public ResponseEntity transform(@PathVariable String id) {
        if (StringUtils.isNotBlank((String)id)) {
            String transformUrl = this.transformUrl;
            String transformMethodUrl = transformUrl + "/task/new";
            String storageUrl = this.storageUrl;
            String sourceUrl = storageUrl + "/rest/storage/download/" + id;
            Storage storage = this.storageService.findById(id);
            String param = "fileurl=" + sourceUrl + "&filename=" + storage.getName() + "&needocr=true&callback=" + storageUrl + "/rest/storage/transform/callback?id=" + id;
            String string = CommonUtil.sendPost((String)transformMethodUrl, (String)param);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/transform/new"})
    public String transformNew(Model model) {
        String transformUrl = this.transformUrl;
        model.addAttribute("transformUrl", (Object)transformUrl);
        return "transform-upload";
    }

    @CrossOrigin
    @RequestMapping(value={"/findById/{id}"})
    @ResponseBody
    public Storage findById(@PathVariable String id) {
        Storage storage = this.storageService.findById(id);
        return storage;
    }

    @CrossOrigin
    @RequestMapping(value={"/find/children/{id}"})
    @ResponseBody
    public List<Storage> findChildren(@PathVariable String id) {
        return this.storageService.findChildren(id);
    }

    @CrossOrigin
    @RequestMapping(value={"/findByIdIn/{ids}"})
    @ResponseBody
    public Set<Storage> findByIdIn(@PathVariable String[] ids) {
        Set storages = this.storageService.findByIds(ids);
        return storages;
    }

    @CrossOrigin
    @RequestMapping(value={"/findByName/{name}"})
    @ResponseBody
    public Set<Storage> findByName(@PathVariable String name) {
        Set storages = this.storageService.findByName(name);
        return storages;
    }
}

