/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.storage.web;

import cn.gtmap.gtcc.storage.config.StorageProperties;
import cn.gtmap.gtcc.storage.service.OSSService;
import cn.gtmap.gtcc.storage.service.StorageService;
import java.sql.Timestamp;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/storage"})
public class IndexController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int CACHE_MAX_AGE = 86400;
    @Autowired
    StorageService storageService;
    @Autowired
    private OSSService ossService;
    private final String storageType;
    private final String appOssEndpoint;
    private final String appOssAccessKeyId;
    private final String appOssAccessKeySecret;
    private final String egovType;
    private final String ossType;

    public IndexController(StorageProperties storageProperties) {
        this.storageType = storageProperties.getStorageType();
        this.appOssEndpoint = storageProperties.getAppOssEndpoint();
        this.appOssAccessKeyId = storageProperties.getAppOssAccessKeyId();
        this.appOssAccessKeySecret = storageProperties.getAppOssAccessKeySecret();
        this.egovType = storageProperties.getEgovType();
        this.ossType = storageProperties.getOssType();
    }

    @GetMapping(value={"/upload"})
    public String uploadForm() {
        return "upload";
    }

    private boolean checkModified(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        if (d1 instanceof Timestamp) {
            long t = d1.getTime() - (long)(((Timestamp)d1).getNanos() / 1000000);
            return t == d2.getTime();
        }
        return d1.equals(d2);
    }
}

