/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.storage.service.impl;

import cn.gtmap.gtcc.domain.storage.Storage;
import cn.gtmap.gtcc.domain.storage.Thumbnail;
import cn.gtmap.gtcc.ex.StorageException;
import cn.gtmap.gtcc.ex.StorageFileNotFoundException;
import cn.gtmap.gtcc.ex.ThumbnailException;
import cn.gtmap.gtcc.storage.config.StorageProperties;
import cn.gtmap.gtcc.storage.dao.ThumbnailRepo;
import cn.gtmap.gtcc.storage.service.StorageService;
import cn.gtmap.gtcc.storage.service.ThumbnailService;
import com.google.common.collect.Sets;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;

@Service
public class ThumbnailServiceImpl
implements ThumbnailService {
    private static final int DEFAULT_WIDTH = 200;
    private static final Set<String> SUPPORT_TYPE = Sets.newHashSet((Object[])new String[]{"image/png", "image/jpeg", "image/gif"});
    private final Path location;
    @Autowired
    private StorageService storageService;
    @Autowired
    private ThumbnailRepo thumbnailRepo;

    public ThumbnailServiceImpl(StorageProperties storageProperties) {
        this.location = Paths.get(storageProperties.getThumbnail(), new String[0]);
    }

    public boolean checkThumbnail(String id, int width, int height) {
        try {
            return this.getThumbnail(id, width, height).isPresent();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Optional<Thumbnail> getThumbnail(String id, int width, int height) throws Exception {
        Optional thumbnail = this.thumbnailRepo.findByStorageIdAndWidthAndHeight(id, width, height);
        if (thumbnail.isPresent()) {
            return thumbnail;
        }
        return Optional.of(this.createThumbnail(id, width, height));
    }

    private Optional<Storage> getStorage(String id) {
        return this.storageService.load(id);
    }

    private Thumbnail createThumbnail(String id, int width, int height) throws Exception {
        Storage storage = (Storage)this.getStorage(id).get();
        if (!SUPPORT_TYPE.contains(storage.getFileType())) {
            throw new ThumbnailException("file type " + storage.getFileType() + " not supported");
        }
        UrlResource resource = new UrlResource(Paths.get(storage.getPath(), new String[0]).toUri());
        if (resource.exists() && resource.isReadable()) {
            Thumbnail thumbnail = this.resizeImage((Resource)resource, new Thumbnail(id, width, height));
            return (Thumbnail)this.thumbnailRepo.save((Object)thumbnail);
        }
        throw new StorageFileNotFoundException(id);
    }

    private Thumbnail resizeImage(Resource resource, Thumbnail thumbnail) throws IOException {
        BufferedImage image = ImageIO.read(resource.getInputStream());
        int ow = ((Image)image).getWidth(null);
        int oh = ((Image)image).getHeight(null);
        int tw = thumbnail.getWidth();
        int th = thumbnail.getHeight();
        if (tw <= -1 && th <= -1) {
            tw = ow;
            th = oh;
        } else if (tw <= -1 || th <= -1) {
            if (tw > -1) {
                th = tw * oh / ow;
            } else if (th > -1) {
                tw = th * ow / oh;
            }
        }
        File dest = this.location.resolve(thumbnail.getThumbnailName()).toFile();
        this.resize((Image)image, dest, tw, th);
        return thumbnail.setFileSize(dest.length()).setPath(dest.getPath());
    }

    private boolean resize(Image src, File dest, int width, int height) throws IOException {
        BufferedImage bfi = new BufferedImage(width, height, 2);
        bfi.getGraphics().drawImage(src, 0, 0, width, height, null);
        bfi.getGraphics().dispose();
        return ImageIO.write((RenderedImage)bfi, "PNG", dest);
    }

    @PostConstruct
    private void init() {
        if (!Files.exists(this.location, new LinkOption[0])) {
            try {
                Files.createDirectories(this.location, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new StorageException("can't init storage thumbnail location " + this.location.toString());
            }
        }
    }
}

