/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.region.web.rest;

import cn.gtmap.gtcc.domain.region.Region;
import cn.gtmap.gtcc.region.service.RegionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/region"})
public class RegionController {
    @Autowired
    RegionService regionService;

    @GetMapping(value={"/root"})
    public Iterable<Region> getRootRegion() {
        return this.regionService.getRootRegions();
    }

    @GetMapping(value={"/{id}"})
    public Region get(@PathVariable(name="id") String id) {
        return this.regionService.getRegion(id);
    }

    @GetMapping(value={"/{id}/parent"})
    public Region getParent(@PathVariable(name="id") String id) {
        return this.regionService.getRegionParent(id);
    }

    @GetMapping(value={"/{id}/children"})
    public Iterable<Region> getChildren(@PathVariable(name="id") String id) {
        return this.regionService.getRegionChildren(id);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET, RequestMethod.POST})
    public Page<Region> searchRegions(@RequestParam(name="type") String type, @RequestParam(name="value") String value, Pageable pageable) {
        if ("name".equals(type)) {
            return this.regionService.searchRegionByName(value, pageable);
        }
        if ("code".equals(type)) {
            return this.regionService.searchRegionByCode(value, pageable);
        }
        throw new RuntimeException("not support region query :" + type);
    }

    @RequestMapping(value={"/level"}, method={RequestMethod.GET, RequestMethod.POST})
    public Page<Region> levelRegions(@RequestParam(name="level") int level, @RequestParam(name="parentId", required=false) String parentId, Pageable pageable) {
        return this.regionService.getRegionByLevel(level, parentId, pageable);
    }

    @PutMapping(value={"/add/{parentId}"})
    public Region add(@PathVariable(name="parentId") String parentId, @RequestBody Region region) {
        return this.regionService.saveRegion(region, parentId);
    }

    @PutMapping(value={"/{id}/disable"})
    public boolean diableChildren(@PathVariable(name="id") String id) {
        this.regionService.disableRegion(id);
        return true;
    }

    @RequestMapping(value={"/{id}/getAllRegions"})
    public Region getAllRegions(@PathVariable(name="id") String id) {
        return this.regionService.findAllRegionById(id);
    }

    @RequestMapping(value={"/{code}/findRegionByCode"})
    public Region findRegionByCode(@PathVariable(name="code") String code) {
        return this.regionService.findRegionByCode(code);
    }
}

