/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.region.service.impl;

import cn.gtmap.gtcc.domain.region.Region;
import cn.gtmap.gtcc.region.dao.RegionRepo;
import cn.gtmap.gtcc.region.service.RegionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(readOnly=true)
public class RegionServiceImpl
implements RegionService {
    @Autowired
    RegionRepo regionRepo;

    public Iterable<Region> getRootRegions() {
        return this.regionRepo.findByParentIsNullAndEnabledTrueOrderByOrder();
    }

    public Region getRegion(String id) {
        return this.regionRepo.findRegionById(id);
    }

    public Iterable<Region> getRegionByCode(String code) {
        return this.regionRepo.findByCodeAndEnabledTrueOrderByOrder(code);
    }

    public Iterable<Region> getRegionByName(String name) {
        return this.regionRepo.findByNameAndEnabledTrueOrderByOrder(name);
    }

    public Region getRegionParent(String regionId) {
        return this.getRegion(regionId).getParent();
    }

    public Iterable<Region> getRegionChildren(String regionId) {
        return this.getRegion(regionId).getChildren();
    }

    public Page<Region> searchRegionByCode(String code, Pageable pageable) {
        return this.regionRepo.findByCodeLikeAndEnabledTrueOrderByOrder(code, pageable);
    }

    public Page<Region> searchRegionByName(String name, Pageable pageable) {
        return this.regionRepo.findByNameContainingAndEnabledOrderByOrder(name, pageable);
    }

    public Page<Region> getRegionByLevel(int level, String parentId, Pageable pageable) {
        if (StringUtils.isEmpty((Object)parentId)) {
            return this.regionRepo.findByLevelAndParentIsNullAndEnabledTrueOrderByOrder(level, pageable);
        }
        return this.regionRepo.findByLevelAndParentIdAndEnabledTrueOrderByOrder(level, parentId, pageable);
    }

    @Transactional
    public Region saveRegion(Region region, String parentId) {
        if (!StringUtils.isEmpty((Object)parentId)) {
            region.setParent(this.getRegion(parentId));
        }
        return (Region)this.regionRepo.save((Object)region);
    }

    @Transactional
    public Region saveRegion(Region region) {
        return this.saveRegion(region, null);
    }

    @Transactional
    public void disableRegion(String id) {
        Region region = this.getRegion(id);
        region.setEnabled(false);
        this.regionRepo.save((Object)region);
    }

    public Region findAllRegionById(String id) {
        return this.getRegion(id);
    }

    public Region findRegionByCode(String code) {
        return this.regionRepo.findRegionByCode(code);
    }
}

