/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.proxy.service.impl;

import cn.gtmap.gtcc.domain.resource.metadata.CapableType;
import cn.gtmap.gtcc.gis.resource.proxy.clients.ResourceGWClient;
import cn.gtmap.gtcc.gis.resource.proxy.service.ResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ResourceServiceImpl
implements ResourceService {
    @Autowired
    ResourceGWClient resourceGWClient;
    @Autowired
    CacheManager cacheManager;

    public String getCapableUrl(String resourceId, String capableType) {
        String key = resourceId.concat("_").concat(capableType);
        String url = this.getCacheUrl(key);
        if (StringUtils.isEmpty((Object)url)) {
            url = this.resourceGWClient.queryResourceCapableUrls(resourceId, capableType);
            this.setCacheUrl(key, url);
        }
        return url;
    }

    private String getCacheUrl(String key) {
        Cache.ValueWrapper vw = this.cacheManager.getCache("rcUrls").get((Object)key);
        return vw != null ? (String)vw.get() : null;
    }

    private void setCacheUrl(String key, String url) {
        this.cacheManager.getCache("rcUrls").put((Object)key, (Object)url);
    }

    public String getCapableUrl(String resourceId, CapableType capableType) {
        return this.getCapableUrl(resourceId, capableType.name());
    }
}

