/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.proxy.filters;

import cn.gtmap.gtcc.domain.resource.metadata.CapableType;
import cn.gtmap.gtcc.gis.resource.proxy.service.ResourceService;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.util.ZuulRuntimeException;
import org.springframework.util.StringUtils;

public class ResourceFilter
extends ZuulFilter {
    private ProxyRequestHelper helper;
    private ResourceService resourceService;

    public ResourceFilter(ProxyRequestHelper helper, ResourceService resourceService) {
        this.helper = helper;
        this.resourceService = resourceService;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 1;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext context = RequestContext.getCurrentContext();
        HttpServletRequest request = context.getRequest();
        String uri = this.helper.buildZuulRequestURI(request);
        String[] us = uri.split("/", 0);
        if (us.length < 4) {
            throw new ZuulRuntimeException(new ZuulException("url format must be '/resp/{id}/{capable}' ", 404, ""));
        }
        String resourceId = us[2];
        String capable = us[3];
        try {
            CapableType type = CapableType.valueOf((String)capable);
            String url = this.resourceService.getCapableUrl(resourceId, type);
            try {
                URL target = new URL(url);
                context.setRouteHost(target);
            }
            catch (MalformedURLException e) {
                throw new ZuulRuntimeException(new ZuulException((Throwable)e, 404, "capable url format error ,[" + url + "] "));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ZuulRuntimeException(new ZuulException((Throwable)e, 404, "capable type [" + capable + "] not support"));
        }
        uri = StringUtils.collectionToDelimitedString(Arrays.asList(us).subList(4, us.length), (String)"", (String)"/", (String)"");
        context.set("requestURI", (Object)uri);
        return null;
    }
}

