/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.proxy.config;

import cn.gtmap.gtcc.gis.resource.proxy.filters.ResourceFilter;
import cn.gtmap.gtcc.gis.resource.proxy.filters.ResourceRouteLocator;
import cn.gtmap.gtcc.gis.resource.proxy.service.ResourceService;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.SimpleHostRoutingFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FilterConfiguration {
    @Bean
    public ProxyRequestHelper proxyRequestHelper(ZuulProperties zuulProperties) {
        ProxyRequestHelper helper = new ProxyRequestHelper();
        helper.setIgnoredHeaders(zuulProperties.getIgnoredHeaders());
        helper.setTraceRequestBody(zuulProperties.isTraceRequestBody());
        return helper;
    }

    @Bean
    public ResourceFilter resourceFilter(ProxyRequestHelper helper, ResourceService resourceService) {
        return new ResourceFilter(helper, resourceService);
    }

    @Bean
    public SimpleHostRoutingFilter simpleHostRoutingFilter(ProxyRequestHelper helper, ZuulProperties properties) {
        return new SimpleHostRoutingFilter(helper, properties);
    }

    @Bean
    public ResourceRouteLocator resourceRouteLocator(ZuulProperties zuulProperties) {
        return new ResourceRouteLocator(zuulProperties);
    }
}

