/*
 * Decompiled with CFR 0.152.
 */
package vector_tile;

import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.ExtendableMessageNano;
import com.google.protobuf.nano.InternalNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.WireFormatNano;
import java.io.IOException;

public interface VectorTile {

    public static final class Tile
    extends ExtendableMessageNano<Tile> {
        public static final int UNKNOWN = 0;
        public static final int POINT = 1;
        public static final int LINESTRING = 2;
        public static final int POLYGON = 3;
        private static volatile Tile[] _emptyArray;
        public Layer[] layers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Tile[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new Tile[0];
                    }
                }
            }
            return _emptyArray;
        }

        public Tile() {
            this.clear();
        }

        public Tile clear() {
            this.layers = Layer.emptyArray();
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.layers != null && this.layers.length > 0) {
                for (int i = 0; i < this.layers.length; ++i) {
                    Layer element = this.layers[i];
                    if (element == null) continue;
                    output.writeMessage(3, (MessageNano)element);
                }
            }
            super.writeTo(output);
        }

        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.layers != null && this.layers.length > 0) {
                for (int i = 0; i < this.layers.length; ++i) {
                    Layer element = this.layers[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize((int)3, (MessageNano)element);
                }
            }
            return size;
        }

        public Tile mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block4: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block4;
                        return this;
                    }
                    case 26: 
                }
                int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)26);
                int i = this.layers == null ? 0 : this.layers.length;
                Layer[] newArray = new Layer[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.layers, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new Layer();
                    input.readMessage((MessageNano)newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new Layer();
                input.readMessage((MessageNano)newArray[i]);
                this.layers = newArray;
            }
        }

        public static Tile parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return (Tile)MessageNano.mergeFrom((MessageNano)new Tile(), (byte[])data);
        }

        public static Tile parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new Tile().mergeFrom(input);
        }

        public static final class Layer
        extends ExtendableMessageNano<Layer> {
            private static volatile Layer[] _emptyArray;
            private int bitField0_;
            public int version;
            public String name;
            public Feature[] features;
            public String[] keys;
            public Value[] values;
            private int extent_;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Layer[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new Layer[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public int getExtent() {
                return this.extent_;
            }

            public Layer setExtent(int value) {
                this.extent_ = value;
                this.bitField0_ |= 1;
                return this;
            }

            public boolean hasExtent() {
                return (this.bitField0_ & 1) != 0;
            }

            public Layer clearExtent() {
                this.extent_ = 4096;
                this.bitField0_ &= 0xFFFFFFFE;
                return this;
            }

            public Layer() {
                this.clear();
            }

            public Layer clear() {
                this.bitField0_ = 0;
                this.version = 1;
                this.name = "";
                this.features = Feature.emptyArray();
                this.keys = WireFormatNano.EMPTY_STRING_ARRAY;
                this.values = Value.emptyArray();
                this.extent_ = 4096;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                Object element;
                int i;
                output.writeString(1, this.name);
                if (this.features != null && this.features.length > 0) {
                    for (i = 0; i < this.features.length; ++i) {
                        element = this.features[i];
                        if (element == null) continue;
                        output.writeMessage(2, (MessageNano)element);
                    }
                }
                if (this.keys != null && this.keys.length > 0) {
                    for (i = 0; i < this.keys.length; ++i) {
                        element = this.keys[i];
                        if (element == null) continue;
                        output.writeString(3, (String)element);
                    }
                }
                if (this.values != null && this.values.length > 0) {
                    for (i = 0; i < this.values.length; ++i) {
                        element = this.values[i];
                        if (element == null) continue;
                        output.writeMessage(4, (MessageNano)element);
                    }
                }
                if ((this.bitField0_ & 1) != 0) {
                    output.writeUInt32(5, this.extent_);
                }
                output.writeUInt32(15, this.version);
                super.writeTo(output);
            }

            protected int computeSerializedSize() {
                int i;
                int size = super.computeSerializedSize();
                size += CodedOutputByteBufferNano.computeStringSize((int)1, (String)this.name);
                if (this.features != null && this.features.length > 0) {
                    for (i = 0; i < this.features.length; ++i) {
                        Feature element = this.features[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize((int)2, (MessageNano)element);
                    }
                }
                if (this.keys != null && this.keys.length > 0) {
                    int dataCount = 0;
                    int dataSize = 0;
                    for (int i2 = 0; i2 < this.keys.length; ++i2) {
                        String element = this.keys[i2];
                        if (element == null) continue;
                        ++dataCount;
                        dataSize += CodedOutputByteBufferNano.computeStringSizeNoTag((String)element);
                    }
                    size += dataSize;
                    size += 1 * dataCount;
                }
                if (this.values != null && this.values.length > 0) {
                    for (i = 0; i < this.values.length; ++i) {
                        Value element = this.values[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize((int)4, (MessageNano)element);
                    }
                }
                if ((this.bitField0_ & 1) != 0) {
                    size += CodedOutputByteBufferNano.computeUInt32Size((int)5, (int)this.extent_);
                }
                return size += CodedOutputByteBufferNano.computeUInt32Size((int)15, (int)this.version);
            }

            public Layer mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block9: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block9;
                            return this;
                        }
                        case 10: {
                            this.name = input.readString();
                            continue block9;
                        }
                        case 18: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)18);
                            int i = this.features == null ? 0 : this.features.length;
                            Object[] newArray = new Feature[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.features, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new Feature();
                                input.readMessage((MessageNano)newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new Feature();
                            input.readMessage((MessageNano)newArray[i]);
                            this.features = newArray;
                            continue block9;
                        }
                        case 26: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)26);
                            int i = this.keys == null ? 0 : this.keys.length;
                            Object[] newArray = new String[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.keys, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = input.readString();
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = input.readString();
                            this.keys = newArray;
                            continue block9;
                        }
                        case 34: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)34);
                            int i = this.values == null ? 0 : this.values.length;
                            Object[] newArray = new Value[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.values, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new Value();
                                input.readMessage((MessageNano)newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new Value();
                            input.readMessage((MessageNano)newArray[i]);
                            this.values = newArray;
                            continue block9;
                        }
                        case 40: {
                            this.extent_ = input.readUInt32();
                            this.bitField0_ |= 1;
                            continue block9;
                        }
                        case 120: 
                    }
                    this.version = input.readUInt32();
                }
            }

            public static Layer parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return (Layer)MessageNano.mergeFrom((MessageNano)new Layer(), (byte[])data);
            }

            public static Layer parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new Layer().mergeFrom(input);
            }
        }

        public static final class Feature
        extends ExtendableMessageNano<Feature> {
            private static volatile Feature[] _emptyArray;
            private int bitField0_;
            private long id_;
            public int[] tags;
            private int type_;
            public int[] geometry;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Feature[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new Feature[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public long getId() {
                return this.id_;
            }

            public Feature setId(long value) {
                this.id_ = value;
                this.bitField0_ |= 1;
                return this;
            }

            public boolean hasId() {
                return (this.bitField0_ & 1) != 0;
            }

            public Feature clearId() {
                this.id_ = 0L;
                this.bitField0_ &= 0xFFFFFFFE;
                return this;
            }

            public int getType() {
                return this.type_;
            }

            public Feature setType(int value) {
                this.type_ = value;
                this.bitField0_ |= 2;
                return this;
            }

            public boolean hasType() {
                return (this.bitField0_ & 2) != 0;
            }

            public Feature clearType() {
                this.type_ = 0;
                this.bitField0_ &= 0xFFFFFFFD;
                return this;
            }

            public Feature() {
                this.clear();
            }

            public Feature clear() {
                this.bitField0_ = 0;
                this.id_ = 0L;
                this.tags = WireFormatNano.EMPTY_INT_ARRAY;
                this.type_ = 0;
                this.geometry = WireFormatNano.EMPTY_INT_ARRAY;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                int element;
                int i;
                int dataSize;
                if ((this.bitField0_ & 1) != 0) {
                    output.writeUInt64(1, this.id_);
                }
                if (this.tags != null && this.tags.length > 0) {
                    dataSize = 0;
                    for (i = 0; i < this.tags.length; ++i) {
                        element = this.tags[i];
                        dataSize += CodedOutputByteBufferNano.computeUInt32SizeNoTag((int)element);
                    }
                    output.writeRawVarint32(18);
                    output.writeRawVarint32(dataSize);
                    for (i = 0; i < this.tags.length; ++i) {
                        output.writeUInt32NoTag(this.tags[i]);
                    }
                }
                if ((this.bitField0_ & 2) != 0) {
                    output.writeInt32(3, this.type_);
                }
                if (this.geometry != null && this.geometry.length > 0) {
                    dataSize = 0;
                    for (i = 0; i < this.geometry.length; ++i) {
                        element = this.geometry[i];
                        dataSize += CodedOutputByteBufferNano.computeUInt32SizeNoTag((int)element);
                    }
                    output.writeRawVarint32(34);
                    output.writeRawVarint32(dataSize);
                    for (i = 0; i < this.geometry.length; ++i) {
                        output.writeUInt32NoTag(this.geometry[i]);
                    }
                }
                super.writeTo(output);
            }

            protected int computeSerializedSize() {
                int element;
                int i;
                int dataSize;
                int size = super.computeSerializedSize();
                if ((this.bitField0_ & 1) != 0) {
                    size += CodedOutputByteBufferNano.computeUInt64Size((int)1, (long)this.id_);
                }
                if (this.tags != null && this.tags.length > 0) {
                    dataSize = 0;
                    for (i = 0; i < this.tags.length; ++i) {
                        element = this.tags[i];
                        dataSize += CodedOutputByteBufferNano.computeUInt32SizeNoTag((int)element);
                    }
                    size += dataSize;
                    ++size;
                    size += CodedOutputByteBufferNano.computeRawVarint32Size((int)dataSize);
                }
                if ((this.bitField0_ & 2) != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size((int)3, (int)this.type_);
                }
                if (this.geometry != null && this.geometry.length > 0) {
                    dataSize = 0;
                    for (i = 0; i < this.geometry.length; ++i) {
                        element = this.geometry[i];
                        dataSize += CodedOutputByteBufferNano.computeUInt32SizeNoTag((int)element);
                    }
                    size += dataSize;
                    ++size;
                    size += CodedOutputByteBufferNano.computeRawVarint32Size((int)dataSize);
                }
                return size;
            }

            public Feature mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block12: while (true) {
                    int[] newArray;
                    int i;
                    int startPos;
                    int limit;
                    int length;
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block12;
                            return this;
                        }
                        case 8: {
                            this.id_ = input.readUInt64();
                            this.bitField0_ |= 1;
                            continue block12;
                        }
                        case 16: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)16);
                            int i2 = this.tags == null ? 0 : this.tags.length;
                            int[] newArray2 = new int[i2 + arrayLength];
                            if (i2 != 0) {
                                System.arraycopy(this.tags, 0, newArray2, 0, i2);
                            }
                            while (i2 < newArray2.length - 1) {
                                newArray2[i2] = input.readUInt32();
                                input.readTag();
                                ++i2;
                            }
                            newArray2[i2] = input.readUInt32();
                            this.tags = newArray2;
                            continue block12;
                        }
                        case 18: {
                            length = input.readRawVarint32();
                            limit = input.pushLimit(length);
                            int arrayLength = 0;
                            startPos = input.getPosition();
                            while (input.getBytesUntilLimit() > 0) {
                                input.readUInt32();
                                ++arrayLength;
                            }
                            input.rewindToPosition(startPos);
                            i = this.tags == null ? 0 : this.tags.length;
                            newArray = new int[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.tags, 0, newArray, 0, i);
                            }
                            while (i < newArray.length) {
                                newArray[i] = input.readUInt32();
                                ++i;
                            }
                            this.tags = newArray;
                            input.popLimit(limit);
                            continue block12;
                        }
                        case 24: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.type_ = value;
                                    this.bitField0_ |= 2;
                                }
                            }
                            continue block12;
                        }
                        case 32: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)32);
                            int i2 = this.geometry == null ? 0 : this.geometry.length;
                            int[] newArray3 = new int[i2 + arrayLength];
                            if (i2 != 0) {
                                System.arraycopy(this.geometry, 0, newArray3, 0, i2);
                            }
                            while (i2 < newArray3.length - 1) {
                                newArray3[i2] = input.readUInt32();
                                input.readTag();
                                ++i2;
                            }
                            newArray3[i2] = input.readUInt32();
                            this.geometry = newArray3;
                            continue block12;
                        }
                        case 34: 
                    }
                    length = input.readRawVarint32();
                    limit = input.pushLimit(length);
                    int arrayLength = 0;
                    startPos = input.getPosition();
                    while (input.getBytesUntilLimit() > 0) {
                        input.readUInt32();
                        ++arrayLength;
                    }
                    input.rewindToPosition(startPos);
                    i = this.geometry == null ? 0 : this.geometry.length;
                    newArray = new int[i + arrayLength];
                    if (i != 0) {
                        System.arraycopy(this.geometry, 0, newArray, 0, i);
                    }
                    while (i < newArray.length) {
                        newArray[i] = input.readUInt32();
                        ++i;
                    }
                    this.geometry = newArray;
                    input.popLimit(limit);
                }
            }

            public static Feature parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return (Feature)MessageNano.mergeFrom((MessageNano)new Feature(), (byte[])data);
            }

            public static Feature parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new Feature().mergeFrom(input);
            }
        }

        public static final class Value
        extends ExtendableMessageNano<Value> {
            private static volatile Value[] _emptyArray;
            private int bitField0_;
            private String stringValue_;
            private float floatValue_;
            private double doubleValue_;
            private long intValue_;
            private long uintValue_;
            private long sintValue_;
            private boolean boolValue_;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Value[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new Value[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public String getStringValue() {
                return this.stringValue_;
            }

            public Value setStringValue(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.stringValue_ = value;
                this.bitField0_ |= 1;
                return this;
            }

            public boolean hasStringValue() {
                return (this.bitField0_ & 1) != 0;
            }

            public Value clearStringValue() {
                this.stringValue_ = "";
                this.bitField0_ &= 0xFFFFFFFE;
                return this;
            }

            public float getFloatValue() {
                return this.floatValue_;
            }

            public Value setFloatValue(float value) {
                this.floatValue_ = value;
                this.bitField0_ |= 2;
                return this;
            }

            public boolean hasFloatValue() {
                return (this.bitField0_ & 2) != 0;
            }

            public Value clearFloatValue() {
                this.floatValue_ = 0.0f;
                this.bitField0_ &= 0xFFFFFFFD;
                return this;
            }

            public double getDoubleValue() {
                return this.doubleValue_;
            }

            public Value setDoubleValue(double value) {
                this.doubleValue_ = value;
                this.bitField0_ |= 4;
                return this;
            }

            public boolean hasDoubleValue() {
                return (this.bitField0_ & 4) != 0;
            }

            public Value clearDoubleValue() {
                this.doubleValue_ = 0.0;
                this.bitField0_ &= 0xFFFFFFFB;
                return this;
            }

            public long getIntValue() {
                return this.intValue_;
            }

            public Value setIntValue(long value) {
                this.intValue_ = value;
                this.bitField0_ |= 8;
                return this;
            }

            public boolean hasIntValue() {
                return (this.bitField0_ & 8) != 0;
            }

            public Value clearIntValue() {
                this.intValue_ = 0L;
                this.bitField0_ &= 0xFFFFFFF7;
                return this;
            }

            public long getUintValue() {
                return this.uintValue_;
            }

            public Value setUintValue(long value) {
                this.uintValue_ = value;
                this.bitField0_ |= 0x10;
                return this;
            }

            public boolean hasUintValue() {
                return (this.bitField0_ & 0x10) != 0;
            }

            public Value clearUintValue() {
                this.uintValue_ = 0L;
                this.bitField0_ &= 0xFFFFFFEF;
                return this;
            }

            public long getSintValue() {
                return this.sintValue_;
            }

            public Value setSintValue(long value) {
                this.sintValue_ = value;
                this.bitField0_ |= 0x20;
                return this;
            }

            public boolean hasSintValue() {
                return (this.bitField0_ & 0x20) != 0;
            }

            public Value clearSintValue() {
                this.sintValue_ = 0L;
                this.bitField0_ &= 0xFFFFFFDF;
                return this;
            }

            public boolean getBoolValue() {
                return this.boolValue_;
            }

            public Value setBoolValue(boolean value) {
                this.boolValue_ = value;
                this.bitField0_ |= 0x40;
                return this;
            }

            public boolean hasBoolValue() {
                return (this.bitField0_ & 0x40) != 0;
            }

            public Value clearBoolValue() {
                this.boolValue_ = false;
                this.bitField0_ &= 0xFFFFFFBF;
                return this;
            }

            public Value() {
                this.clear();
            }

            public Value clear() {
                this.bitField0_ = 0;
                this.stringValue_ = "";
                this.floatValue_ = 0.0f;
                this.doubleValue_ = 0.0;
                this.intValue_ = 0L;
                this.uintValue_ = 0L;
                this.sintValue_ = 0L;
                this.boolValue_ = false;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if ((this.bitField0_ & 1) != 0) {
                    output.writeString(1, this.stringValue_);
                }
                if ((this.bitField0_ & 2) != 0) {
                    output.writeFloat(2, this.floatValue_);
                }
                if ((this.bitField0_ & 4) != 0) {
                    output.writeDouble(3, this.doubleValue_);
                }
                if ((this.bitField0_ & 8) != 0) {
                    output.writeInt64(4, this.intValue_);
                }
                if ((this.bitField0_ & 0x10) != 0) {
                    output.writeUInt64(5, this.uintValue_);
                }
                if ((this.bitField0_ & 0x20) != 0) {
                    output.writeSInt64(6, this.sintValue_);
                }
                if ((this.bitField0_ & 0x40) != 0) {
                    output.writeBool(7, this.boolValue_);
                }
                super.writeTo(output);
            }

            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if ((this.bitField0_ & 1) != 0) {
                    size += CodedOutputByteBufferNano.computeStringSize((int)1, (String)this.stringValue_);
                }
                if ((this.bitField0_ & 2) != 0) {
                    size += CodedOutputByteBufferNano.computeFloatSize((int)2, (float)this.floatValue_);
                }
                if ((this.bitField0_ & 4) != 0) {
                    size += CodedOutputByteBufferNano.computeDoubleSize((int)3, (double)this.doubleValue_);
                }
                if ((this.bitField0_ & 8) != 0) {
                    size += CodedOutputByteBufferNano.computeInt64Size((int)4, (long)this.intValue_);
                }
                if ((this.bitField0_ & 0x10) != 0) {
                    size += CodedOutputByteBufferNano.computeUInt64Size((int)5, (long)this.uintValue_);
                }
                if ((this.bitField0_ & 0x20) != 0) {
                    size += CodedOutputByteBufferNano.computeSInt64Size((int)6, (long)this.sintValue_);
                }
                if ((this.bitField0_ & 0x40) != 0) {
                    size += CodedOutputByteBufferNano.computeBoolSize((int)7, (boolean)this.boolValue_);
                }
                return size;
            }

            public Value mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block10: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block10;
                            return this;
                        }
                        case 10: {
                            this.stringValue_ = input.readString();
                            this.bitField0_ |= 1;
                            continue block10;
                        }
                        case 21: {
                            this.floatValue_ = input.readFloat();
                            this.bitField0_ |= 2;
                            continue block10;
                        }
                        case 25: {
                            this.doubleValue_ = input.readDouble();
                            this.bitField0_ |= 4;
                            continue block10;
                        }
                        case 32: {
                            this.intValue_ = input.readInt64();
                            this.bitField0_ |= 8;
                            continue block10;
                        }
                        case 40: {
                            this.uintValue_ = input.readUInt64();
                            this.bitField0_ |= 0x10;
                            continue block10;
                        }
                        case 48: {
                            this.sintValue_ = input.readSInt64();
                            this.bitField0_ |= 0x20;
                            continue block10;
                        }
                        case 56: 
                    }
                    this.boolValue_ = input.readBool();
                    this.bitField0_ |= 0x40;
                }
            }

            public static Value parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return (Value)MessageNano.mergeFrom((MessageNano)new Value(), (byte[])data);
            }

            public static Value parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new Value().mergeFrom(input);
            }
        }
    }
}

