/*
 * Decompiled with CFR 0.152.
 */
package no.ecc.vectortile;

import com.google.protobuf.nano.MessageNano;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import vector_tile.VectorTile;

public class VectorTileEncoder {
    private final Map<String, Layer> layers = new LinkedHashMap<String, Layer>();
    private final int extent;
    private final Geometry clipGeometry;
    private final boolean autoScale;
    private int x = 0;
    private int y = 0;

    public VectorTileEncoder() {
        this(4096, 8, true);
    }

    public VectorTileEncoder(int extent) {
        this(extent, 8, true);
    }

    public VectorTileEncoder(int extent, int clipBuffer, boolean autoScale) {
        this.extent = extent;
        this.autoScale = autoScale;
        int size = autoScale ? 256 : extent;
        this.clipGeometry = VectorTileEncoder.createTileEnvelope(clipBuffer, size);
    }

    private static Geometry createTileEnvelope(int buffer, int size) {
        Coordinate[] coords;
        coords = new Coordinate[]{new Coordinate((double)(0 - buffer), (double)(size + buffer)), new Coordinate((double)(size + buffer), (double)(size + buffer)), new Coordinate((double)(size + buffer), (double)(0 - buffer)), new Coordinate((double)(0 - buffer), (double)(0 - buffer)), coords[0]};
        return new GeometryFactory().createPolygon(coords);
    }

    public void addFeature(String layerName, Map<String, ?> attributes, Geometry geometry) {
        if (geometry instanceof MultiPolygon || geometry.getClass().equals(GeometryCollection.class)) {
            this.splitAndAddFeatures(layerName, attributes, (GeometryCollection)geometry);
            return;
        }
        if (geometry instanceof Polygon && geometry.getArea() < 1.0) {
            return;
        }
        if (geometry instanceof LineString && geometry.getLength() < 1.0) {
            return;
        }
        if (geometry instanceof Point) {
            if (!this.clipCovers(geometry)) {
                return;
            }
        } else {
            geometry = this.clipGeometry(geometry);
        }
        if (geometry instanceof MultiPolygon || geometry.getClass().equals(GeometryCollection.class)) {
            this.splitAndAddFeatures(layerName, attributes, (GeometryCollection)geometry);
            return;
        }
        if (geometry.isEmpty()) {
            return;
        }
        Layer layer = this.layers.get(layerName);
        if (layer == null) {
            layer = new Layer();
            this.layers.put(layerName, layer);
        }
        Feature feature = new Feature();
        feature.geometry = geometry;
        for (Map.Entry<String, ?> e : attributes.entrySet()) {
            if (e.getValue() == null) continue;
            feature.tags.add(layer.key(e.getKey()));
            feature.tags.add(layer.value(e.getValue()));
        }
        layer.features.add(feature);
    }

    protected boolean clipCovers(Geometry geom) {
        if (geom instanceof Point) {
            Point p = (Point)geom;
            return this.clipGeometry.getEnvelopeInternal().covers(p.getCoordinate());
        }
        return this.clipGeometry.covers(geom);
    }

    protected Geometry clipGeometry(Geometry geometry) {
        try {
            Geometry original = geometry;
            geometry = this.clipGeometry.intersection(original);
            if (geometry.isEmpty() && original.intersects(this.clipGeometry)) {
                Geometry originalViaWkt = new WKTReader().read(original.toText());
                geometry = this.clipGeometry.intersection(originalViaWkt);
            }
            return geometry;
        }
        catch (TopologyException e) {
            return geometry;
        }
        catch (ParseException e1) {
            return geometry;
        }
    }

    private void splitAndAddFeatures(String layerName, Map<String, ?> attributes, GeometryCollection geometry) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry subGeometry = geometry.getGeometryN(i);
            this.addFeature(layerName, attributes, subGeometry);
        }
    }

    public byte[] encode() {
        VectorTile.Tile tile = new VectorTile.Tile();
        ArrayList<VectorTile.Tile.Layer> tileLayers = new ArrayList<VectorTile.Tile.Layer>();
        for (Map.Entry<String, Layer> e : this.layers.entrySet()) {
            String layerName = e.getKey();
            Layer layer = e.getValue();
            VectorTile.Tile.Layer tileLayer = new VectorTile.Tile.Layer();
            tileLayer.version = 2;
            tileLayer.name = layerName;
            tileLayer.keys = layer.keys();
            ArrayList<VectorTile.Tile.Value> values = new ArrayList<VectorTile.Tile.Value>();
            for (Object value : layer.values()) {
                VectorTile.Tile.Value tileValue = new VectorTile.Tile.Value();
                if (value instanceof String) {
                    tileValue.setStringValue((String)value);
                } else if (value instanceof Integer) {
                    tileValue.setSintValue(((Integer)value).intValue());
                } else if (value instanceof Long) {
                    tileValue.setSintValue((Long)value);
                } else if (value instanceof Float) {
                    tileValue.setFloatValue(((Float)value).floatValue());
                } else if (value instanceof Double) {
                    tileValue.setDoubleValue((Double)value);
                } else {
                    tileValue.setStringValue(value.toString());
                }
                values.add(tileValue);
            }
            tileLayer.values = values.toArray(new VectorTile.Tile.Value[values.size()]);
            tileLayer.setExtent(this.extent);
            ArrayList<VectorTile.Tile.Feature> features = new ArrayList<VectorTile.Tile.Feature>();
            for (Feature feature : layer.features) {
                Geometry geometry = feature.geometry;
                VectorTile.Tile.Feature featureBuilder = new VectorTile.Tile.Feature();
                featureBuilder.tags = VectorTileEncoder.toIntArray(feature.tags);
                featureBuilder.setType(VectorTileEncoder.toGeomType(geometry));
                featureBuilder.geometry = VectorTileEncoder.toIntArray(this.commands(geometry));
                features.add(featureBuilder);
            }
            tileLayer.features = features.toArray(new VectorTile.Tile.Feature[features.size()]);
            tileLayers.add(tileLayer);
        }
        tile.layers = tileLayers.toArray(new VectorTile.Tile.Layer[tileLayers.size()]);
        return MessageNano.toByteArray((MessageNano)tile);
    }

    static int[] toIntArray(List<Integer> ints) {
        int[] r = new int[ints.size()];
        for (int i = 0; i < ints.size(); ++i) {
            r[i] = ints.get(i);
        }
        return r;
    }

    static int toGeomType(Geometry geometry) {
        if (geometry instanceof Point) {
            return 1;
        }
        if (geometry instanceof MultiPoint) {
            return 1;
        }
        if (geometry instanceof LineString) {
            return 2;
        }
        if (geometry instanceof MultiLineString) {
            return 2;
        }
        if (geometry instanceof Polygon) {
            return 3;
        }
        return 0;
    }

    static boolean shouldClosePath(Geometry geometry) {
        return geometry instanceof Polygon || geometry instanceof LinearRing;
    }

    List<Integer> commands(Geometry geometry) {
        this.x = 0;
        this.y = 0;
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            ArrayList<Integer> commands = new ArrayList<Integer>();
            LineString exteriorRing = polygon.getExteriorRing();
            if (!CGAlgorithms.isCCW((Coordinate[])exteriorRing.getCoordinates())) {
                exteriorRing = (LineString)exteriorRing.reverse();
            }
            commands.addAll(this.commands(exteriorRing.getCoordinates(), true));
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                LineString interiorRing = polygon.getInteriorRingN(i);
                if (CGAlgorithms.isCCW((Coordinate[])interiorRing.getCoordinates())) {
                    interiorRing = (LineString)interiorRing.reverse();
                }
                commands.addAll(this.commands(interiorRing.getCoordinates(), true));
            }
            return commands;
        }
        if (geometry instanceof MultiLineString) {
            ArrayList<Integer> commands = new ArrayList<Integer>();
            GeometryCollection gc = (GeometryCollection)geometry;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                commands.addAll(this.commands(gc.getGeometryN(i).getCoordinates(), false));
            }
            return commands;
        }
        return this.commands(geometry.getCoordinates(), VectorTileEncoder.shouldClosePath(geometry), geometry instanceof MultiPoint);
    }

    List<Integer> commands(Coordinate[] cs, boolean closePathAtEnd) {
        return this.commands(cs, closePathAtEnd, false);
    }

    List<Integer> commands(Coordinate[] cs, boolean closePathAtEnd, boolean multiPoint) {
        if (cs.length == 0) {
            throw new IllegalArgumentException("empty geometry");
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        int lineToIndex = 0;
        int lineToLength = 0;
        double scale = this.autoScale ? (double)this.extent / 256.0 : 1.0;
        for (int i = 0; i < cs.length; ++i) {
            Coordinate c = cs[i];
            if (i == 0) {
                r.add(VectorTileEncoder.commandAndLength(1, multiPoint ? cs.length : 1));
            }
            int _x = (int)Math.round(c.x * scale);
            int _y = (int)Math.round(c.y * scale);
            if (i > 0 && _x == this.x && _y == this.y) {
                --lineToLength;
                continue;
            }
            if (closePathAtEnd && cs.length > 1 && i == cs.length - 1 && cs[0].equals((Object)c)) {
                --lineToLength;
                continue;
            }
            r.add(VectorTileEncoder.zigZagEncode(_x - this.x));
            r.add(VectorTileEncoder.zigZagEncode(_y - this.y));
            this.x = _x;
            this.y = _y;
            if (i != 0 || cs.length <= 1 || multiPoint) continue;
            lineToIndex = r.size();
            lineToLength = cs.length - 1;
            r.add(VectorTileEncoder.commandAndLength(2, lineToLength));
        }
        if (lineToIndex > 0) {
            if (lineToLength == 0) {
                r.remove(lineToIndex);
            } else {
                r.set(lineToIndex, VectorTileEncoder.commandAndLength(2, lineToLength));
            }
        }
        if (closePathAtEnd) {
            r.add(VectorTileEncoder.commandAndLength(7, 1));
        }
        return r;
    }

    static int commandAndLength(int command, int repeat) {
        return repeat << 3 | command;
    }

    static int zigZagEncode(int n) {
        return n << 1 ^ n >> 31;
    }

    private static final class Feature {
        Geometry geometry;
        final List<Integer> tags = new ArrayList<Integer>();

        private Feature() {
        }
    }

    private static final class Layer {
        final List<Feature> features = new ArrayList<Feature>();
        private final Map<String, Integer> keys = new LinkedHashMap<String, Integer>();
        private final Map<Object, Integer> values = new LinkedHashMap<Object, Integer>();

        private Layer() {
        }

        public Integer key(String key) {
            Integer i = this.keys.get(key);
            if (i == null) {
                i = this.keys.size();
                this.keys.put(key, i);
            }
            return i;
        }

        public String[] keys() {
            ArrayList<String> r = new ArrayList<String>(this.keys.keySet());
            return r.toArray(new String[r.size()]);
        }

        public Integer value(Object value) {
            Integer i = this.values.get(value);
            if (i == null) {
                i = this.values.size();
                this.values.put(value, i);
            }
            return i;
        }

        public List<Object> values() {
            return Collections.unmodifiableList(new ArrayList<Object>(this.values.keySet()));
        }
    }
}

