/*
 * Decompiled with CFR 0.152.
 */
package no.ecc.vectortile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import no.ecc.vectortile.Filter;
import vector_tile.VectorTile;

public class VectorTileDecoder {
    private boolean autoScale = true;

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public FeatureIterable decode(byte[] data) throws IOException {
        return this.decode(data, Filter.ALL);
    }

    public FeatureIterable decode(byte[] data, String layerName) throws IOException {
        return this.decode(data, new Filter.Single(layerName));
    }

    public FeatureIterable decode(byte[] data, Set<String> layerNames) throws IOException {
        return this.decode(data, new Filter.Any(layerNames));
    }

    public FeatureIterable decode(byte[] data, Filter filter) throws IOException {
        VectorTile.Tile tile = VectorTile.Tile.parseFrom(data);
        return new FeatureIterable(tile, filter, this.autoScale);
    }

    static int zigZagDecode(int n) {
        return n >> 1 ^ -(n & 1);
    }

    public static final class Feature {
        private final String layerName;
        private final int extent;
        private final Geometry geometry;
        private final Map<String, Object> attributes;

        public Feature(String layerName, int extent, Geometry geometry, Map<String, Object> attributes) {
            this.layerName = layerName;
            this.extent = extent;
            this.geometry = geometry;
            this.attributes = attributes;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public int getExtent() {
            return this.extent;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }
    }

    private static final class FeatureIterator
    implements Iterator<Feature> {
        private final GeometryFactory gf = new GeometryFactory();
        private final Filter filter;
        private final Iterator<VectorTile.Tile.Layer> layerIterator;
        private Iterator<VectorTile.Tile.Feature> featureIterator;
        private int extent;
        private String layerName;
        private double scale;
        private boolean autoScale;
        private final List<String> keys = new ArrayList<String>();
        private final List<Object> values = new ArrayList<Object>();
        private Feature next;

        public FeatureIterator(VectorTile.Tile tile, Filter filter, boolean autoScale) {
            this.layerIterator = Arrays.asList(tile.layers).iterator();
            this.filter = filter;
            this.autoScale = autoScale;
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.next != null;
        }

        @Override
        public Feature next() {
            this.findNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Feature n = this.next;
            this.next = null;
            return n;
        }

        private void findNext() {
            block3: {
                if (this.next != null) {
                    return;
                }
                while (this.featureIterator == null || !this.featureIterator.hasNext()) {
                    if (!this.layerIterator.hasNext()) {
                        this.next = null;
                        break block3;
                    }
                    VectorTile.Tile.Layer layer = this.layerIterator.next();
                    if (!this.filter.include(layer.name)) continue;
                    this.parseLayer(layer);
                }
                this.next = this.parseFeature(this.featureIterator.next());
            }
        }

        private void parseLayer(VectorTile.Tile.Layer layer) {
            this.layerName = layer.name;
            this.extent = layer.getExtent();
            this.scale = this.autoScale ? (double)this.extent / 256.0 : 1.0;
            this.keys.clear();
            this.keys.addAll(Arrays.asList(layer.keys));
            this.values.clear();
            for (VectorTile.Tile.Value value : layer.values) {
                if (value.hasBoolValue()) {
                    this.values.add(value.getBoolValue());
                    continue;
                }
                if (value.hasDoubleValue()) {
                    this.values.add(value.getDoubleValue());
                    continue;
                }
                if (value.hasFloatValue()) {
                    this.values.add(Float.valueOf(value.getFloatValue()));
                    continue;
                }
                if (value.hasIntValue()) {
                    this.values.add(value.getIntValue());
                    continue;
                }
                if (value.hasSintValue()) {
                    this.values.add(value.getSintValue());
                    continue;
                }
                if (value.hasUintValue()) {
                    this.values.add(value.getUintValue());
                    continue;
                }
                if (value.hasStringValue()) {
                    this.values.add(value.getStringValue());
                    continue;
                }
                this.values.add(null);
            }
            this.featureIterator = Arrays.asList(layer.features).iterator();
        }

        private Feature parseFeature(VectorTile.Tile.Feature feature) {
            int tagsCount = feature.tags.length;
            HashMap<String, Object> attributes = new HashMap<String, Object>(tagsCount / 2);
            int tagIdx = 0;
            while (tagIdx < feature.tags.length) {
                String key = this.keys.get(feature.tags[tagIdx++]);
                Object value = this.values.get(feature.tags[tagIdx++]);
                attributes.put(key, value);
            }
            int x = 0;
            int y = 0;
            ArrayList coordsList = new ArrayList();
            ArrayList coords = null;
            int geometryCount = feature.geometry.length;
            int length = 0;
            int command = 0;
            int i = 0;
            while (i < geometryCount) {
                if (length <= 0) {
                    length = feature.geometry[i++];
                    command = length & 7;
                    length >>= 3;
                }
                if (length <= 0) continue;
                if (command == 1) {
                    coords = new ArrayList();
                    coordsList.add(coords);
                }
                if (command == 7) {
                    if (feature.getType() != 1 && !coords.isEmpty()) {
                        coords.add(coords.get(0));
                    }
                    --length;
                    continue;
                }
                int dx = feature.geometry[i++];
                int dy = feature.geometry[i++];
                --length;
                dx = VectorTileDecoder.zigZagDecode(dx);
                dy = VectorTileDecoder.zigZagDecode(dy);
                Coordinate coord = new Coordinate((double)(x += dx) / this.scale, (double)(y += dy) / this.scale);
                coords.add(coord);
            }
            GeometryCollection geometry = null;
            switch (feature.getType()) {
                case 2: {
                    ArrayList<LineString> lineStrings = new ArrayList<LineString>();
                    for (List list : coordsList) {
                        lineStrings.add(this.gf.createLineString(list.toArray(new Coordinate[list.size()])));
                    }
                    if (lineStrings.size() == 1) {
                        geometry = (Geometry)lineStrings.get(0);
                        break;
                    }
                    if (lineStrings.size() <= 1) break;
                    geometry = this.gf.createMultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
                    break;
                }
                case 1: {
                    ArrayList allCoords = new ArrayList();
                    for (List list : coordsList) {
                        allCoords.addAll(list);
                    }
                    if (allCoords.size() == 1) {
                        geometry = this.gf.createPoint((Coordinate)allCoords.get(0));
                        break;
                    }
                    if (allCoords.size() <= 1) break;
                    geometry = this.gf.createMultiPoint(allCoords.toArray(new Coordinate[allCoords.size()]));
                    break;
                }
                case 3: {
                    ArrayList<LinearRing> arrayList = new ArrayList<LinearRing>();
                    for (List list : coordsList) {
                        arrayList.add(this.gf.createLinearRing(list.toArray(new Coordinate[list.size()])));
                    }
                    if (arrayList.size() <= 0) break;
                    LinearRing linearRing = (LinearRing)arrayList.get(0);
                    LinearRing[] linearRingArray = arrayList.subList(1, arrayList.size()).toArray(new LinearRing[arrayList.size() - 1]);
                    geometry = this.gf.createPolygon(linearRing, linearRingArray);
                    break;
                }
                case 0: {
                    break;
                }
            }
            if (geometry == null) {
                geometry = this.gf.createGeometryCollection(new Geometry[0]);
            }
            return new Feature(this.layerName, this.extent, (Geometry)geometry, Collections.unmodifiableMap(attributes));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FeatureIterable
    implements Iterable<Feature> {
        private final VectorTile.Tile tile;
        private final Filter filter;
        private boolean autoScale;

        public FeatureIterable(VectorTile.Tile tile, Filter filter, boolean autoScale) {
            this.tile = tile;
            this.filter = filter;
            this.autoScale = autoScale;
        }

        @Override
        public Iterator<Feature> iterator() {
            return new FeatureIterator(this.tile, this.filter, this.autoScale);
        }

        public List<Feature> asList() {
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (Feature feature : this) {
                features.add(feature);
            }
            return features;
        }

        public Collection<String> getLayerNames() {
            HashSet<String> layerNames = new HashSet<String>();
            for (VectorTile.Tile.Layer layer : this.tile.layers) {
                layerNames.add(layer.name);
            }
            return Collections.unmodifiableSet(layerNames);
        }
    }
}

