/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.vt.mapbox;

import cn.gtmap.gtcc.gis.core.geo.TileMapContent;
import cn.gtmap.gtcc.gis.core.vt.VectorTileBuilder;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Rectangle;
import java.util.Map;
import no.ecc.vectortile.VectorTileEncoder;
import no.ecc.vectortile.VectorTileEncoderNoClip;

public class VectorTileBuilderImpl
implements VectorTileBuilder {
    private VectorTileEncoder encoder;
    private int width;
    private int height;

    public VectorTileBuilderImpl(Rectangle tileSize) {
        this.width = tileSize.width;
        this.height = tileSize.height;
        int extent = Math.max(this.height, this.width);
        int clipBuf = extent / 32;
        this.encoder = new VectorTileEncoderNoClip(extent, clipBuf, false);
    }

    @Override
    public void addFeature(String layerName, String featureId, Geometry geometry, Map<String, Object> properties) {
        this.encoder.addFeature(layerName, properties, geometry);
    }

    @Override
    public TileMapContent build() {
        byte[] contents = this.encoder.encode();
        return new TileMapContent().setContents(contents).setTileWidth(this.width).setTileHeight(this.height).setMineType("application/vnd.mapbox-vector-tile").setExtension("pbf");
    }
}

