/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.vt;

import cn.gtmap.gtcc.gis.core.vt.Pipeline;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LineStringExtracter;
import com.vividsolutions.jts.geom.util.PointExtracter;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.ScreenMap;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class PipelineBuilder {
    private static final double PIXEL_BASE_SAMPLE_SIZE = 0.25;
    Context context;
    final int clipBBOXSizeIncreasePixels = 12;
    private Pipeline first = Pipeline.END;
    private Pipeline last = Pipeline.END;
    private static final ThreadLocal<GridToEnvelopeMapper> gridToEnvelopeMappers = new ThreadLocal<GridToEnvelopeMapper>(){

        @Override
        protected GridToEnvelopeMapper initialValue() {
            GridToEnvelopeMapper mapper = new GridToEnvelopeMapper();
            mapper.setPixelAnchor(PixelInCell.CELL_CORNER);
            return mapper;
        }
    };

    private PipelineBuilder(Context context) {
        this.context = context;
    }

    public static PipelineBuilder newBuilder(ReferencedEnvelope renderingArea, Rectangle paintArea, CoordinateReferenceSystem sourceCrs, double overSampleFactor, int queryBuffer) throws FactoryException {
        Context context = PipelineBuilder.createContext(renderingArea, paintArea, sourceCrs, overSampleFactor, queryBuffer);
        return new PipelineBuilder(context);
    }

    private static Context createContext(ReferencedEnvelope mapArea, Rectangle paintArea, CoordinateReferenceSystem sourceCrs, double overSampleFactor, int queryBuffer) throws FactoryException {
        double[] spans_targetCRS;
        double[] spans_sourceCRS;
        Context context = new Context();
        context.renderingArea = mapArea;
        context.paintArea = paintArea;
        context.sourceCrs = sourceCrs;
        context.worldToScreen = PipelineBuilder.worldToScreenTransform(mapArea, paintArea.getWidth(), paintArea.getHeight());
        context.queryBuffer = queryBuffer;
        boolean wrap = false;
        context.projectionHandler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mapArea, (CoordinateReferenceSystem)sourceCrs, (boolean)false);
        CoordinateReferenceSystem mapCrs = context.renderingArea.getCoordinateReferenceSystem();
        context.sourceToTargetCrs = PipelineBuilder.buildTransform(sourceCrs, mapCrs);
        context.targetToScreen = ProjectiveTransform.create((AffineTransform)context.worldToScreen);
        context.sourceToScreen = ConcatenatedTransform.create((MathTransform)context.sourceToTargetCrs, (MathTransform)context.targetToScreen);
        try {
            MathTransform screenToWorld = context.sourceToScreen.inverse();
            spans_sourceCRS = Decimator.computeGeneralizationDistances((MathTransform)screenToWorld, (Rectangle)context.paintArea, (double)0.8);
            spans_targetCRS = Decimator.computeGeneralizationDistances((MathTransform)context.targetToScreen.inverse(), (Rectangle)context.paintArea, (double)1.0);
            context.pixelSizeInTargetCRS = Math.max(spans_targetCRS[0], spans_targetCRS[1]);
        }
        catch (TransformException e) {
            throw Throwables.propagate((Throwable)e);
        }
        context.screenSimplificationDistance = 0.25 / overSampleFactor;
        context.targetCRSSimplificationDistance = Math.min(spans_targetCRS[0], spans_targetCRS[1]) / overSampleFactor;
        context.screenMap = new ScreenMap(0, 0, paintArea.width, paintArea.height);
        context.screenMap.setSpans(spans_sourceCRS[0] / overSampleFactor, spans_sourceCRS[1] / overSampleFactor);
        context.screenMap.setTransform(context.sourceToScreen);
        return context;
    }

    private static MathTransform buildTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) throws FactoryException {
        Preconditions.checkNotNull((Object)sourceCRS, (Object)"sourceCRS");
        Preconditions.checkNotNull((Object)destCRS, (Object)"destCRS");
        MathTransform transform = null;
        if (sourceCRS.getCoordinateSystem().getDimension() >= 3) {
            MathTransform toWgs84_3d = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
            MathTransform toWgs84_2d = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            transform = ConcatenatedTransform.create((MathTransform)toWgs84_3d, (MathTransform)toWgs84_2d);
            sourceCRS = DefaultGeographicCRS.WGS84;
        }
        MathTransform2D sourceToTarget = (MathTransform2D)CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        if (transform == null) {
            return sourceToTarget;
        }
        if (sourceToTarget.isIdentity()) {
            return transform;
        }
        return ConcatenatedTransform.create((MathTransform)transform, (MathTransform)sourceToTarget);
    }

    private static AffineTransform worldToScreenTransform(ReferencedEnvelope mapExtent, Rectangle paintArea) {
        Envelope2D genvelope = new Envelope2D((org.opengis.geometry.Envelope)mapExtent);
        GridToEnvelopeMapper m = gridToEnvelopeMappers.get();
        m.setPixelAnchor(PixelInCell.CELL_CENTER);
        try {
            m.setGridRange((GridEnvelope)new GridEnvelope2D(paintArea));
            m.setEnvelope((org.opengis.geometry.Envelope)genvelope);
            AffineTransform af = m.createAffineTransform().createInverse();
            return af;
        }
        catch (MismatchedDimensionException e) {
            return null;
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    public static AffineTransform worldToScreenTransform(ReferencedEnvelope mapExtent, double width, double height) {
        boolean swap;
        CoordinateReferenceSystem crs = mapExtent.getCoordinateReferenceSystem();
        boolean bl = swap = crs != null && CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST;
        if (swap) {
            mapExtent = new ReferencedEnvelope(mapExtent.getMinY(), mapExtent.getMaxY(), mapExtent.getMinX(), mapExtent.getMaxX(), null);
        }
        double scaleX = width / mapExtent.getWidth();
        double scaleY = height / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + height;
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        if (swap) {
            at.concatenate(new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        }
        return at;
    }

    public PipelineBuilder preprocess() {
        this.addLast(new PreProcess(this.context.projectionHandler, this.context.screenMap));
        return this;
    }

    public PipelineBuilder collapseCollections() {
        this.addLast(new CollapseCollections());
        return this;
    }

    public Pipeline build() {
        return this.first;
    }

    private void addLast(Pipeline step) {
        if (this.first == Pipeline.END) {
            this.last = this.first = step;
        } else {
            this.last.setNext(step);
            this.last = step;
        }
    }

    public PipelineBuilder transform(boolean transformToScreenCoordinates) {
        MathTransform sourceToScreen = this.context.sourceToScreen;
        MathTransform sourceToTargetCrs = this.context.sourceToTargetCrs;
        MathTransform tx = transformToScreenCoordinates ? sourceToScreen : sourceToTargetCrs;
        this.addLast(new Transform(tx));
        return this;
    }

    public PipelineBuilder simplify(boolean isTransformToScreenCoordinates) {
        double pixelDistance = this.context.screenSimplificationDistance;
        double simplificationDistance = this.context.targetCRSSimplificationDistance;
        double distanceTolerance = isTransformToScreenCoordinates ? pixelDistance : simplificationDistance;
        this.addLast(new Simplify(distanceTolerance));
        return this;
    }

    public PipelineBuilder clip(boolean clipToMapBounds, boolean transformToScreenCoordinates) {
        if (clipToMapBounds) {
            ReferencedEnvelope clippingEnvelope;
            if (transformToScreenCoordinates) {
                Rectangle screen = this.context.paintArea;
                Envelope paintArea = new Envelope(0.0, screen.getWidth(), 0.0, screen.getHeight());
                paintArea.expandBy((double)(12 + this.context.queryBuffer));
                clippingEnvelope = paintArea;
            } else {
                ReferencedEnvelope renderingArea = this.context.renderingArea;
                renderingArea.expandBy((double)(12 + this.context.queryBuffer) * this.context.pixelSizeInTargetCRS);
                clippingEnvelope = renderingArea;
            }
            this.addLast(new ClipRemoveDegenerateGeometries((Envelope)clippingEnvelope));
        }
        return this;
    }

    public static final class ClipRemoveDegenerateGeometries
    extends Clip {
        ClipRemoveDegenerateGeometries(Envelope clippingEnvelope) {
            super(clippingEnvelope);
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            if (geom == null || geom.isEmpty()) {
                return null;
            }
            if (geom.getGeometryType() == "GeometryCollection") {
                return this.collectionClip((GeometryCollection)geom);
            }
            Geometry result = super._run(geom);
            if (result == null || result.isEmpty()) {
                return null;
            }
            if (geom instanceof Point || geom instanceof MultiPoint) {
                return this.onlyPoints(result);
            }
            if (geom instanceof LineString || geom instanceof MultiLineString) {
                return this.onlyLines(result);
            }
            if (geom instanceof Polygon || geom instanceof MultiPolygon) {
                return this.onlyPolygon(result);
            }
            return result;
        }

        private Geometry collectionClip(GeometryCollection geom) throws Exception {
            ArrayList<Geometry> result = new ArrayList<Geometry>();
            for (int t = 0; t < geom.getNumGeometries(); ++t) {
                Geometry g = geom.getGeometryN(0);
                Geometry clipped = this._run(g);
                if (clipped == null || clipped.isEmpty()) continue;
                result.add(clipped);
            }
            if (result.size() == 0) {
                return null;
            }
            return new GeometryCollection(result.toArray(new Geometry[result.size()]), geom.getFactory());
        }

        private Geometry onlyPolygon(Geometry result) {
            if (result instanceof Polygon || result instanceof MultiPolygon) {
                return result;
            }
            List polys = PolygonExtracter.getPolygons((Geometry)result);
            if (polys.size() == 0) {
                return null;
            }
            if (polys.size() == 1) {
                return (Polygon)polys.get(0);
            }
            return new MultiPolygon(polys.toArray(new Polygon[polys.size()]), result.getFactory());
        }

        private Geometry onlyLines(Geometry result) {
            if (result instanceof LineString || result instanceof MultiLineString) {
                return result;
            }
            List lines = LineStringExtracter.getLines((Geometry)result);
            if (lines.size() == 0) {
                return null;
            }
            if (lines.size() == 1) {
                return (LineString)lines.get(0);
            }
            return new MultiLineString(lines.toArray(new LineString[lines.size()]), result.getFactory());
        }

        private Geometry onlyPoints(Geometry result) {
            if (result instanceof Point || result instanceof MultiPoint) {
                return result;
            }
            List pts = PointExtracter.getPoints((Geometry)result);
            if (pts.size() == 0) {
                return null;
            }
            if (pts.size() == 1) {
                return (Point)pts.get(0);
            }
            return new MultiPoint(pts.toArray(new Point[pts.size()]), result.getFactory());
        }
    }

    protected static class Clip
    extends Pipeline {
        private final Envelope clippingEnvelope;

        Clip(Envelope clippingEnvelope) {
            this.clippingEnvelope = clippingEnvelope;
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            GeometryClipper clipper = new GeometryClipper(this.clippingEnvelope);
            try {
                return clipper.clip(geom, true);
            }
            catch (Exception e) {
                return clipper.clip(geom, false);
            }
        }
    }

    private static final class Simplify
    extends Pipeline {
        private final double distanceTolerance;

        Simplify(double distanceTolerance) {
            this.distanceTolerance = distanceTolerance;
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            if (geom.getDimension() == 0) {
                return geom;
            }
            TopologyPreservingSimplifier simplifier = new TopologyPreservingSimplifier(geom);
            simplifier.setDistanceTolerance(this.distanceTolerance);
            Geometry simplified = simplifier.getResultGeometry();
            return simplified;
        }
    }

    private static final class Transform
    extends Pipeline {
        private final MathTransform tx;

        Transform(MathTransform tx) {
            this.tx = tx;
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            Geometry transformed = JTS.transform((Geometry)geom, (MathTransform)this.tx);
            return transformed;
        }
    }

    private static final class PreProcess
    extends Pipeline {
        private final ProjectionHandler projectionHandler;
        private final ScreenMap screenMap;

        PreProcess(@Nullable ProjectionHandler projectionHandler, ScreenMap screenMap) {
            this.projectionHandler = projectionHandler;
            this.screenMap = screenMap;
        }

        @Override
        protected Geometry _run(Geometry geom) throws TransformException, FactoryException {
            Envelope env;
            Geometry preProcessed = geom;
            if (this.projectionHandler != null) {
                preProcessed = this.projectionHandler.preProcess(geom);
            }
            if (preProcessed == null || preProcessed.isEmpty()) {
                return EMPTY;
            }
            if (preProcessed.getDimension() > 0 && this.screenMap.canSimplify(env = preProcessed.getEnvelopeInternal())) {
                if (this.screenMap.checkAndSet(env)) {
                    return EMPTY;
                }
                preProcessed = this.screenMap.getSimplifiedShape(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), preProcessed.getFactory(), preProcessed.getClass());
            }
            return preProcessed;
        }
    }

    private static final class CollapseCollections
    extends Pipeline {
        private CollapseCollections() {
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            if (geom instanceof GeometryCollection && geom.getNumGeometries() == 1) {
                return geom.getGeometryN(0);
            }
            return geom;
        }
    }

    static class Context {
        @Nullable
        ProjectionHandler projectionHandler;
        MathTransform sourceToTargetCrs;
        MathTransform targetToScreen;
        MathTransform sourceToScreen;
        ReferencedEnvelope renderingArea;
        Rectangle paintArea;
        public ScreenMap screenMap;
        public CoordinateReferenceSystem sourceCrs;
        public AffineTransform worldToScreen;
        public double targetCRSSimplificationDistance;
        public double screenSimplificationDistance;
        public double pixelSizeInTargetCRS;
        public int queryBuffer;

        Context() {
        }
    }
}

