/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.vt;

import com.google.common.base.Preconditions;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;

public abstract class Pipeline {
    protected static final Geometry EMPTY = new GeometryFactory().createPoint((Coordinate)null);
    static final Pipeline END = new Pipeline(){

        @Override
        public final Geometry execute(Geometry geom) {
            return geom;
        }

        @Override
        protected final Geometry _run(Geometry geom) {
            throw new UnsupportedOperationException();
        }
    };
    private Pipeline next = END;

    void setNext(Pipeline step) {
        Preconditions.checkNotNull((Object)this.next);
        this.next = step;
    }

    public Geometry execute(Geometry geom) throws Exception {
        Preconditions.checkNotNull((Object)this.next, (Object)this.getClass().getName());
        Geometry g = this._run(geom);
        if (g == null || g.isEmpty()) {
            return EMPTY;
        }
        return this.next.execute(g);
    }

    protected abstract Geometry _run(Geometry var1) throws Exception;
}

