/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.util;

import com.esri.sde.sdk.pe.PeCSTransformations;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeDatum;
import com.esri.sde.sdk.pe.PeFactory;
import com.esri.sde.sdk.pe.PeFactoryCodelist;
import com.esri.sde.sdk.pe.PeGTTransformations;
import com.esri.sde.sdk.pe.PeGeogTransformations;
import com.esri.sde.sdk.pe.PeGeographicCS;
import com.esri.sde.sdk.pe.PeParameters;
import com.esri.sde.sdk.pe.PePrimeMeridian;
import com.esri.sde.sdk.pe.PeProjectedCS;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.esri.sde.sdk.pe.PeSpheroid;
import com.esri.sde.sdk.pe.PeString;
import com.esri.sde.sdk.pe.PeUnit;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.JTSFactoryFinder;

public final class SRTransformations {
    private static final Log logger = LogFactory.getLog(SRTransformations.class);
    private static GeometryFactory factory = JTSFactoryFinder.getGeometryFactory();
    private static Map<String, PeGeogTransformations> geoTranSet = new HashMap<String, PeGeogTransformations>();
    private static List<String> notAvailTrans = new ArrayList<String>();

    private static PeParameters[] getBj54ToXian80Parameters() {
        PeParameters[] params = new PeParameters[16];
        try {
            params[0] = PeFactory.parameter((int)100040);
            params[1] = PeFactory.parameter((int)100041);
            params[2] = PeFactory.parameter((int)100042);
            params[3] = PeFactory.parameter((int)100043);
            params[4] = PeFactory.parameter((int)100044);
            params[5] = PeFactory.parameter((int)100045);
            params[6] = PeFactory.parameter((int)100046);
            params[0].setValue(70.755569);
            params[1].setValue(-122.298703);
            params[2].setValue(-90.003599);
            params[3].setValue(0.800101183432487);
            params[4].setValue(-2.41296820940103);
            params[5].setValue(0.123738257267633);
            params[6].setValue(9.683612);
        }
        catch (PeProjectionException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return params;
    }

    public static PeCoordinateSystem getCoordinateSystem(int srid) throws PeProjectionException {
        return PeFactory.coordsys((int)srid);
    }

    public static PeCoordinateSystem getCoordinateSystem(String wkt) throws PeProjectionException {
        return PeCoordinateSystem.fromString((String)wkt);
    }

    public static Geometry project(Geometry geometry, String from, String to) throws PeProjectionException {
        PeCoordinateSystem fromCS = SRTransformations.getCoordinateSystem(from);
        PeCoordinateSystem toCS = SRTransformations.getCoordinateSystem(to);
        if (geometry instanceof Point) {
            return SRTransformations.project((Point)geometry, fromCS, toCS);
        }
        if (geometry instanceof MultiPoint) {
            return SRTransformations.project((MultiPoint)geometry, fromCS, toCS);
        }
        if (geometry instanceof LineString) {
            return SRTransformations.project((LineString)geometry, fromCS, toCS);
        }
        if (geometry instanceof MultiLineString) {
            return SRTransformations.project((MultiLineString)geometry, fromCS, toCS);
        }
        if (geometry instanceof Polygon) {
            return SRTransformations.project((Polygon)geometry, fromCS, toCS);
        }
        if (geometry instanceof MultiPolygon) {
            return SRTransformations.project((MultiPolygon)geometry, fromCS, toCS);
        }
        if (geometry instanceof GeometryCollection) {
            return SRTransformations.project((GeometryCollection)geometry, fromCS, toCS);
        }
        throw new RuntimeException("current geometry don't supported");
    }

    private static Point project(Point point, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        double[] coords = SRTransformations.project(new double[]{point.getX(), point.getY()}, 1, from, to);
        return factory.createPoint(new Coordinate(coords[0], coords[1]));
    }

    private static MultiPoint project(MultiPoint multiPoint, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        double[] coords = SRTransformations.getCoordinates(multiPoint.getCoordinates());
        Coordinate[] coordinates = SRTransformations.array2Coords(SRTransformations.project(coords, coords.length / 2, from, to));
        return factory.createMultiPoint(coordinates);
    }

    private static LineString project(LineString lineString, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        double[] coords = SRTransformations.getCoordinates(lineString.getCoordinates());
        Coordinate[] coordinates = SRTransformations.array2Coords(SRTransformations.project(coords, coords.length / 2, from, to));
        return factory.createLineString(coordinates);
    }

    private static MultiLineString project(MultiLineString multiLineString, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        LineString[] lineStrings = new LineString[multiLineString.getNumGeometries()];
        for (int i = 0; i < lineStrings.length; ++i) {
            lineStrings[i] = SRTransformations.project((LineString)multiLineString.getGeometryN(i), from, to);
        }
        return factory.createMultiLineString(lineStrings);
    }

    private static Polygon project(Polygon polygon, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        LinearRing shell = SRTransformations.lineString2LinearRing(polygon.getExteriorRing(), from, to);
        LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
        if (holes.length > 0) {
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                holes[i] = SRTransformations.lineString2LinearRing(polygon.getInteriorRingN(i), from, to);
            }
        }
        return factory.createPolygon(shell, holes);
    }

    private static MultiPolygon project(MultiPolygon multiPolygon, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        Polygon[] polygons = new Polygon[multiPolygon.getNumGeometries()];
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            polygons[i] = SRTransformations.project((Polygon)multiPolygon.getGeometryN(i), from, to);
        }
        return factory.createMultiPolygon(polygons);
    }

    private static GeometryCollection project(GeometryCollection geometryCollection, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        Geometry[] geometries = new Geometry[geometryCollection.getNumGeometries()];
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            geometries[i] = SRTransformations.project(geometryCollection.getGeometryN(i), from.toString(), to.toString());
        }
        return factory.createGeometryCollection(geometries);
    }

    private static LinearRing lineString2LinearRing(LineString lineString, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        return SRTransformations.createLinearRing(SRTransformations.project(lineString, from, to).getCoordinates());
    }

    private static LinearRing createLinearRing(Coordinate[] coordinates) {
        return factory.createLinearRing(coordinates);
    }

    private static Coordinate[] array2Coords(double[] coords) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int i = 0; i < coords.length; i += 2) {
            Coordinate coordinate = new Coordinate(coords[i], coords[i + 1]);
            coordinates.add(coordinate);
        }
        return coordinates.toArray(new Coordinate[0]);
    }

    private static double[] getCoordinates(Coordinate[] coordinates) {
        ArrayList<Double> coords = new ArrayList<Double>();
        for (Coordinate c : coordinates) {
            coords.add(c.x);
            coords.add(c.y);
        }
        return ArrayUtils.toPrimitive((Double[])coords.toArray(new Double[0]));
    }

    public static double[] project(double[] coords, int count, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        PeProjectedCS pt;
        if (from.isEqual(to)) {
            return coords;
        }
        PeGeographicCS gf = from instanceof PeGeographicCS ? (PeGeographicCS)from : null;
        PeGeographicCS gt = to instanceof PeGeographicCS ? (PeGeographicCS)to : null;
        PeProjectedCS pf = from instanceof PeProjectedCS ? (PeProjectedCS)from : null;
        PeProjectedCS peProjectedCS = pt = to instanceof PeProjectedCS ? (PeProjectedCS)to : null;
        if (gf != null && gt != null) {
            return SRTransformations.projectGCS(coords, count, gf, gt);
        }
        if (gf != null && pt != null) {
            SRTransformations.projectGCS(coords, count, gf, pt.getGeogCoordSys());
            PeCSTransformations.geogToProj((PeProjectedCS)pt, (int)count, (double[])coords);
            return coords;
        }
        if (pf != null && gt != null) {
            PeCSTransformations.projToGeog((PeProjectedCS)pf, (int)count, (double[])coords);
            SRTransformations.projectGCS(coords, count, pf.getGeogCoordSys(), gt);
            return coords;
        }
        if (pf != null && pt != null) {
            PeCSTransformations.projToGeog((PeProjectedCS)pf, (int)count, (double[])coords);
            SRTransformations.projectGCS(coords, count, pf.getGeogCoordSys(), pt.getGeogCoordSys());
            PeCSTransformations.geogToProj((PeProjectedCS)pt, (int)count, (double[])coords);
            return coords;
        }
        return coords;
    }

    private static double[] projectGCS(double[] coords, int count, PeGeographicCS from, PeGeographicCS to) throws PeProjectionException {
        if (from.isEqual(to)) {
            return coords;
        }
        String key = from.getName().concat(to.getName());
        PeGeogTransformations gt = geoTranSet.get(key);
        if (gt == null) {
            if (notAvailTrans.contains(key)) {
                logger.info((Object)("GCS trans not found [" + from + " ## " + to + "]"));
                return coords;
            }
            gt = SRTransformations.findGeogTran(from, to);
            if (gt == null) {
                notAvailTrans.add(key);
            } else {
                geoTranSet.put(key, gt);
            }
        }
        if (gt != null) {
            try {
                if (from.isEqual(gt.getGeogCS1())) {
                    PeGTTransformations.geog1ToGeog2((PeGeogTransformations)gt, (int)count, (double[])coords, null);
                } else {
                    PeGTTransformations.geog2ToGeog1((PeGeogTransformations)gt, (int)count, (double[])coords, null);
                }
            }
            catch (PeProjectionException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
        }
        return coords;
    }

    private static PeGeogTransformations findGeogTran(PeGeographicCS gcs1, PeGeographicCS gcs2) throws PeProjectionException {
        int[] codes = PeFactoryCodelist.geogtran();
        PeGeogTransformations imatch = null;
        for (int i = 0; i < codes.length; ++i) {
            PeGeogTransformations gt = PeFactory.geogtran((int)codes[i]);
            if (gt == null) continue;
            SRTransformations.isEqual(gt.getGeogCS1(), gcs1);
            if (gt.getGeogCS1().isEqual(gcs1) && gt.getGeogCS2().isEqual(gcs2)) {
                return gt;
            }
            if (!gt.getGeogCS1().isEqual(gcs2) || !gt.getGeogCS2().isEqual(gcs1)) continue;
            imatch = gt;
        }
        return imatch;
    }

    private static boolean isEqual(PeGeographicCS gcs1, PeGeographicCS gcs2) {
        return gcs1 != null && gcs2 != null && PeString.equals((String)gcs1.getName(), (String)gcs2.getName()) && gcs1.getDatum().isEqual(gcs2.getDatum()) && gcs1.getPrimeM().isEqual(gcs2.getPrimeM()) && gcs1.getUnit().isEqual(gcs2.getUnit());
    }

    static {
        String name = "GCS_Beijing_1954GCS_Xian_1980";
        try {
            PeParameters[] transParams = SRTransformations.getBj54ToXian80Parameters();
            PeGeographicCS peGeographicCSFrom = new PeGeographicCS("GCS_Beijing_1954", new PeDatum("D_Beijing_1954", new PeSpheroid("Krasovsky_1940", 6378245.0, 0.003352329869259135)), new PePrimeMeridian("Greenwich", 0.0), new PeUnit("Degree", 0.0174532925199433));
            PeGeographicCS peGeographicCSTo = new PeGeographicCS("Xian_1980", new PeDatum("D_Xian_1980", new PeSpheroid("Xian_1980", 6378140.0, 0.0033528131778969143)), new PePrimeMeridian("Greenwich", 0.0), new PeUnit("Degree", 0.0174532925199433));
            PeGeogTransformations peGeogTransformations = new PeGeogTransformations(name, peGeographicCSFrom, peGeographicCSTo, PeFactory.method((int)109607), transParams);
            geoTranSet.put(name, peGeogTransformations);
        }
        catch (PeProjectionException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

