/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import java.util.Collection;

public class PolygonUtil {
    public static Geometry validate(Geometry geom) {
        if (geom instanceof Polygon) {
            if (geom.isValid()) {
                geom.normalize();
                return geom;
            }
            Polygonizer polygonizer = new Polygonizer();
            PolygonUtil.addPolygon((Polygon)geom, polygonizer);
            return PolygonUtil.toPolygonGeometry(polygonizer.getPolygons(), geom.getFactory());
        }
        if (geom instanceof MultiPolygon) {
            if (geom.isValid()) {
                geom.normalize();
                return geom;
            }
            Polygonizer polygonizer = new Polygonizer();
            int n = geom.getNumGeometries();
            while (n-- > 0) {
                PolygonUtil.addPolygon((Polygon)geom.getGeometryN(n), polygonizer);
            }
            return PolygonUtil.toPolygonGeometry(polygonizer.getPolygons(), geom.getFactory());
        }
        return geom;
    }

    static void addPolygon(Polygon polygon, Polygonizer polygonizer) {
        PolygonUtil.addLineString(polygon.getExteriorRing(), polygonizer);
        int n = polygon.getNumInteriorRing();
        while (n-- > 0) {
            PolygonUtil.addLineString(polygon.getInteriorRingN(n), polygonizer);
        }
    }

    static void addLineString(LineString lineString, Polygonizer polygonizer) {
        if (lineString instanceof LinearRing) {
            lineString = lineString.getFactory().createLineString(lineString.getCoordinateSequence());
        }
        Point point = lineString.getFactory().createPoint(lineString.getCoordinateN(0));
        Geometry toAdd = lineString.union((Geometry)point);
        polygonizer.add(toAdd);
    }

    static Geometry toPolygonGeometry(Collection<Polygon> polygons, GeometryFactory factory) {
        switch (polygons.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Geometry)polygons.iterator().next();
            }
        }
        return factory.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }
}

