/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.util;

import cn.gtmap.gtcc.gis.core.util.SRTransformations;
import cn.gtmap.gtcc.utils.UUIDGenerator;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.util.Assert;

public final class GeometryUtils {
    private static final String TYPE = "type";
    private static GeometryFactory factory = JTSFactoryFinder.getGeometryFactory();

    public static final Object parseGeoJSON(String value) {
        if (StringUtils.isBlank((String)value)) {
            throw new RuntimeException("GeoJSON can't be blank");
        }
        try {
            Map geo = (Map)JSON.parseObject((String)value, Map.class);
            if (!geo.containsKey(GeoTag.type.name())) {
                throw new RuntimeException("GeoJSON must have type key");
            }
            GeoTag tag = GeoTag.getTag((String)geo.get(GeoTag.type.name()));
            if (tag == null) {
                throw new RuntimeException("unsupport geometry type : [ " + JSON.toJSONString((Object)value) + " ]");
            }
            switch (tag) {
                case Polygon: {
                    return GeometryUtils.createPolygon((JSONArray)geo.get(GeoTag.coordinates.name()));
                }
                case GeometryCollection: {
                    return GeometryUtils.createGeometryCollection((JSONArray)geo.get(GeoTag.geometries.name()));
                }
                case MultiPolygon: {
                    return GeometryUtils.createMultiPolygon((JSONArray)geo.get(GeoTag.coordinates.name()));
                }
                case Feature: {
                    return GeometryUtils.createFeature(geo);
                }
                case FeatureCollection: {
                    return GeometryUtils.createFeatureCollection((JSONArray)geo.get(GeoTag.features.name()));
                }
                case Point: {
                    return GeometryUtils.createPoint((JSONArray)geo.get(GeoTag.coordinates.name()));
                }
                case LineString: {
                    return GeometryUtils.createLine((JSONArray)geo.get(GeoTag.coordinates.name()));
                }
                case MultiPoint: {
                    return GeometryUtils.createMultiPoint((JSONArray)geo.get(GeoTag.coordinates.name()));
                }
                case MultiLineString: {
                    return GeometryUtils.createMultiLine((JSONArray)geo.get(GeoTag.coordinates.name()));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(" Value isn't well-know format GeoJSON. detail error : [ " + e.getLocalizedMessage() + " ] ");
        }
        return null;
    }

    public static final Geometry convertSeShape(SeShape seShape) {
        Point geometry = null;
        try {
            double[][][] coordinates = seShape.getAllCoords(Integer.MAX_VALUE);
            JSONArray polygons = new JSONArray();
            JSONArray lineString = new JSONArray();
            JSONArray point = new JSONArray();
            switch (seShape.getType()) {
                case 1: {
                    for (int i = 0; i < coordinates.length; ++i) {
                        double[][] temp = coordinates[i];
                        for (int j = 0; j < temp.length; ++j) {
                            for (int m = 0; m < temp[j].length; ++m) {
                                point = new JSONArray();
                                point.add((Object)temp[j][m]);
                                point.add((Object)temp[j][++m]);
                            }
                        }
                    }
                    if (point.size() <= 0) break;
                    geometry = GeometryUtils.createPoint(point);
                    break;
                }
                case 4: {
                    for (int i = 0; i < coordinates.length; ++i) {
                        double[][] temp = coordinates[i];
                        for (int j = 0; j < temp.length; ++j) {
                            lineString = new JSONArray();
                            for (int m = 0; m < temp[j].length; ++m) {
                                point = new JSONArray();
                                point.add((Object)temp[j][m]);
                                point.add((Object)temp[j][++m]);
                                lineString.add((Object)point);
                            }
                        }
                    }
                    if (lineString.size() <= 0) break;
                    geometry = GeometryUtils.createLine(lineString);
                    break;
                }
                case 8: {
                    for (int i = 0; i < coordinates.length; ++i) {
                        double[][] temp = coordinates[i];
                        JSONArray polygon = new JSONArray();
                        for (int j = 0; j < temp.length; ++j) {
                            lineString = new JSONArray();
                            for (int m = 0; m < temp[j].length; ++m) {
                                point = new JSONArray();
                                point.add((Object)temp[j][m]);
                                point.add((Object)temp[j][++m]);
                                lineString.add((Object)point);
                            }
                            polygon.add((Object)lineString);
                        }
                        polygons.addAll((Collection)polygon);
                    }
                    if (polygons.size() <= 0) break;
                    geometry = GeometryUtils.createPolygon(polygons);
                    break;
                }
                case 264: {
                    for (int i = 0; i < coordinates.length; ++i) {
                        double[][] temp = coordinates[i];
                        JSONArray polygon = new JSONArray();
                        for (int j = 0; j < temp.length; ++j) {
                            lineString = new JSONArray();
                            for (int m = 0; m < temp[j].length; ++m) {
                                point = new JSONArray();
                                point.add((Object)temp[j][m]);
                                point.add((Object)temp[j][++m]);
                                lineString.add((Object)point);
                            }
                            polygon.add((Object)lineString);
                        }
                        polygons.add((Object)polygon);
                    }
                    if (polygons.size() <= 0) break;
                    geometry = GeometryUtils.createMultiPolygon(polygons);
                    break;
                }
            }
        }
        catch (SeException e) {
            throw new RuntimeException(e.getMessage());
        }
        return geometry;
    }

    public static SimpleFeature createFeature(Map value) {
        Geometry geometry = null;
        CoordinateReferenceSystem crs = null;
        Map<String, Object> properties = null;
        if (value.containsKey(GeoTag.geometry.name())) {
            geometry = GeometryUtils.createGeometry((JSONObject)value.get(GeoTag.geometry.name()));
        }
        if (value.containsKey(GeoTag.crs.name())) {
            crs = GeometryUtils.createCRS((JSONObject)value.get(GeoTag.crs.name()));
        }
        if (value.containsKey(GeoTag.properties.name())) {
            properties = GeometryUtils.createPros((JSONObject)value.get(GeoTag.properties.name()));
        }
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(GeoTag.Feature.name());
        if (GeometryUtils.notNull(geometry)) {
            typeBuilder.add(GeoTag.geometry.name(), Geometry.class);
        }
        if (GeometryUtils.notNull(properties)) {
            for (String key : properties.keySet()) {
                typeBuilder.add(key, properties.get(key) != null ? properties.get(key).getClass() : String.class);
            }
        }
        if (GeometryUtils.notNull(crs)) {
            typeBuilder.add(GeoTag.crs.name(), String.class, crs);
        }
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        if (GeometryUtils.notNull(geometry)) {
            featureBuilder.add((Object)geometry);
        }
        if (GeometryUtils.notNull(properties)) {
            for (String key : properties.keySet()) {
                featureBuilder.add(properties.get(key));
            }
        }
        return featureBuilder.buildFeature(GeoTag.Feature.name().concat(UUIDGenerator.generate()));
    }

    private static FeatureCollection createFeatureCollection(JSONArray array) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        for (Object o : array) {
            collection.add(GeometryUtils.createFeature((Map)o));
        }
        return collection;
    }

    private static Geometry createGeometry(JSONObject value) {
        GeoTag tag = GeoTag.getTag((String)value.get((Object)GeoTag.type.name()));
        if (tag == null) {
            throw new RuntimeException("unsupport geometry type : [ " + JSON.toJSONString((Object)value) + " ]");
        }
        switch (tag) {
            case Polygon: {
                return GeometryUtils.createPolygon((JSONArray)value.get((Object)GeoTag.coordinates.name()));
            }
            case GeometryCollection: {
                return GeometryUtils.createGeometryCollection((JSONArray)value.get((Object)GeoTag.geometries.name()));
            }
            case MultiPolygon: {
                return GeometryUtils.createMultiPolygon((JSONArray)value.get((Object)GeoTag.coordinates.name()));
            }
            case Point: {
                return GeometryUtils.createPoint((JSONArray)value.get((Object)GeoTag.coordinates.name()));
            }
            case LineString: {
                return GeometryUtils.createLine((JSONArray)value.get((Object)GeoTag.coordinates.name()));
            }
            case MultiPoint: {
                return GeometryUtils.createMultiPoint((JSONArray)value.get((Object)GeoTag.coordinates.name()));
            }
            case MultiLineString: {
                return GeometryUtils.createMultiLine((JSONArray)value.get((Object)GeoTag.coordinates.name()));
            }
        }
        throw new RuntimeException("unsupport geometry type : [ " + tag.name() + " ]");
    }

    public static GeometryCollection createGeometryCollection(JSONArray array) {
        ArrayList<Object> geometries = new ArrayList<Object>();
        for (Object o : array) {
            JSONObject value = (JSONObject)o;
            GeoTag tag = GeoTag.getTag((String)value.get((Object)GeoTag.type.name()));
            if (tag == null) {
                throw new RuntimeException("unsupport geometry type : [ " + JSON.toJSONString((Object)value) + " ]");
            }
            switch (tag) {
                case Polygon: {
                    geometries.add(GeometryUtils.createPolygon((JSONArray)value.get((Object)GeoTag.coordinates.name())));
                    break;
                }
                case MultiPolygon: {
                    geometries.add(GeometryUtils.createMultiPolygon((JSONArray)value.get((Object)GeoTag.coordinates.name())));
                    break;
                }
                case Point: {
                    geometries.add(GeometryUtils.createPoint((JSONArray)value.get((Object)GeoTag.coordinates.name())));
                    break;
                }
                case LineString: {
                    geometries.add(GeometryUtils.createLine((JSONArray)value.get((Object)GeoTag.coordinates.name())));
                    break;
                }
                case MultiPoint: {
                    geometries.add(GeometryUtils.createMultiPoint((JSONArray)value.get((Object)GeoTag.coordinates.name())));
                    break;
                }
                case MultiLineString: {
                    geometries.add(GeometryUtils.createMultiLine((JSONArray)value.get((Object)GeoTag.coordinates.name())));
                    break;
                }
            }
        }
        return factory.createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    public static Polygon createPolygon(JSONArray array) {
        if (array.size() == 0) {
            throw new RuntimeException("Polygon specified with no rings");
        }
        try {
            LinearRing shell = GeometryUtils.createLinearRing(array.getJSONArray(0));
            LinearRing[] holes = null;
            if (array.size() > 1) {
                holes = new LinearRing[array.size() - 1];
                for (int i = 1; i < array.size(); ++i) {
                    holes[i - 1] = GeometryUtils.createLinearRing(array.getJSONArray(i));
                }
            }
            return factory.createPolygon(shell, holes);
        }
        catch (Exception e) {
            throw new RuntimeException("Polygon coordinates format error");
        }
    }

    public static MultiPolygon createMultiPolygon(JSONArray array) {
        if (array.size() == 0) {
            throw new RuntimeException(" no coordinates in MultiPolygon");
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Object o : array) {
            polygons.add(GeometryUtils.createPolygon((JSONArray)o));
        }
        return factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private static LinearRing createLinearRing(JSONArray array) {
        if (!GeometryUtils.isLineClosed(array)) {
            array.add(array.get(0));
        }
        return factory.createLinearRing(GeometryUtils.coordinates(array));
    }

    private static boolean isLineClosed(JSONArray array) {
        JSONArray first = (JSONArray)array.get(0);
        JSONArray last = (JSONArray)array.get(array.size() - 1);
        return GeometryUtils.coordinate(first).equals((Object)GeometryUtils.coordinate(last));
    }

    public static Point createPoint(JSONArray array) {
        return factory.createPoint(GeometryUtils.coordinate(array));
    }

    public static Point createPoint(double x, double y) {
        Coordinate c = new Coordinate();
        c.x = x;
        c.y = y;
        return factory.createPoint(c);
    }

    private static MultiPoint createMultiPoint(JSONArray array) {
        return factory.createMultiPoint(GeometryUtils.coordinates(array));
    }

    public static LineString createLine(JSONArray array) {
        Assert.notNull((Object)array, (String)" line coordinates can't be null ");
        return factory.createLineString(GeometryUtils.coordinates(array));
    }

    private static MultiLineString createMultiLine(JSONArray array) {
        return factory.createMultiLineString(GeometryUtils.lineStrings(array));
    }

    public static CoordinateReferenceSystem createCRS(JSONObject value) {
        try {
            GeoTag tag = GeoTag.getTag((String)value.get((Object)GeoTag.type.name()));
            if (tag == null) {
                throw new RuntimeException("unsupport geometry type : [ " + JSON.toJSONString((Object)value) + " ]");
            }
            JSONObject pros = (JSONObject)value.get((Object)GeoTag.properties.name());
            switch (tag) {
                case name: {
                    String code = (String)pros.get((Object)GeoTag.name.name());
                    try {
                        if (code == null) {
                            return null;
                        }
                        int c = Integer.parseInt(code);
                        return CRS.parseWKT((String)SRTransformations.getCoordinateSystem(c).toString());
                    }
                    catch (NumberFormatException e) {
                        if (code.contains("EPSG:")) {
                            PeCoordinateSystem peCoordinateSystem = SRTransformations.getCoordinateSystem(Integer.valueOf(code.substring("EPSG:".length(), code.length())));
                            if (peCoordinateSystem != null) {
                                return CRS.parseWKT((String)peCoordinateSystem.toString());
                            }
                            return CRS.decode((String)code, (boolean)true);
                        }
                        return CRS.decode((String)code, (boolean)true);
                    }
                }
                case value: {
                    String wkt = (String)pros.get((Object)GeoTag.value.name());
                    wkt = SRTransformations.getCoordinateSystem(wkt).toString();
                    return CRS.parseWKT((String)wkt);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("parse crs exception : [ " + e.getLocalizedMessage() + " ]");
        }
        catch (PeProjectionException e) {
            throw new RuntimeException("parse crs exception : [ " + e.getLocalizedMessage() + " ]");
        }
        return null;
    }

    private static Map<String, Object> createPros(JSONObject value) {
        HashMap<String, Object> pros = new HashMap<String, Object>(16);
        for (String key : value.keySet()) {
            pros.put(key, value.get((Object)key));
        }
        return pros;
    }

    private static Coordinate coordinate(JSONArray array) {
        Assert.notNull((Object)array, (String)" coordinates can't be null ");
        Coordinate c = new Coordinate();
        c.x = array.getDoubleValue(0);
        c.y = array.getDoubleValue(1);
        return c;
    }

    private static Coordinate[] coordinates(JSONArray array) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (Object o : array) {
            coordinates.add(GeometryUtils.coordinate((JSONArray)o));
        }
        return coordinates.toArray(new Coordinate[0]);
    }

    private static LineString[] lineStrings(JSONArray array) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (Object o : array) {
            lines.add(GeometryUtils.createLine((JSONArray)o));
        }
        return lines.toArray(new LineString[0]);
    }

    private static boolean notNull(Object value) {
        return value != null;
    }

    public static Map createCrsMap(String value) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        HashMap<String, String> prop = new HashMap<String, String>();
        try {
            int srid = Integer.valueOf(value);
            map.put(TYPE, "name");
            prop.put("name", "EPSG:".concat(value));
            map.put("properties", prop);
        }
        catch (NumberFormatException e) {
            map.put(TYPE, "value");
            prop.put("value", value);
            map.put("properties", prop);
        }
        return map;
    }

    public static enum GeoTag {
        type,
        geometry,
        geometries,
        properties,
        crs,
        name,
        bbox,
        features,
        Point,
        MultiPoint,
        LineString,
        MultiLineString,
        Polygon,
        MultiPolygon,
        GeometryCollection,
        Feature,
        FeatureCollection,
        coordinates,
        value,
        wkt;


        public static GeoTag getTag(String name) {
            Assert.notNull((Object)name, (String)"name can't be null -- get GeoTag");
            for (GeoTag tag : GeoTag.values()) {
                if (!tag.name().equalsIgnoreCase(name)) continue;
                return tag;
            }
            return null;
        }
    }
}

