/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.util;

public class CoordTransform {
    private static final double X_PI = 52.35987755982988;
    private static final double PI = Math.PI;
    private static final double A = 6378245.0;
    private static final double EE = 0.006693421622965943;

    public static double[] bd09ToGcj02(double lng, double lat) {
        double x = lng - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        double gdLng = z * Math.cos(theta);
        double gdLat = z * Math.sin(theta);
        return new double[]{gdLng, gdLat};
    }

    public static double[] gcj02ToBd09(double lng, double lat) {
        double z = Math.sqrt(lng * lng + lat * lat) + 2.0E-5 * Math.sin(lat * 52.35987755982988);
        double theta = Math.atan2(lat, lng) + 3.0E-6 * Math.cos(lng * 52.35987755982988);
        double bdLng = z * Math.cos(theta) + 0.0065;
        double bdLat = z * Math.sin(theta) + 0.006;
        return new double[]{bdLng, bdLat};
    }

    public static double transformLat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    public static double transformLng(double lng, double lat) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * Math.PI) + 40.0 * Math.sin(lng / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lng / 12.0 * Math.PI) + 300.0 * Math.sin(lng / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    public static double[] wgs84ToGcj02(double lng, double lat) {
        if (CoordTransform.outOfChina(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dlat = CoordTransform.transformLat(lng - 105.0, lat - 35.0);
        double dlng = CoordTransform.transformLng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (6335552.717000426 / (magic * sqrtmagic) * Math.PI);
        dlng = dlng * 180.0 / (6378245.0 / sqrtmagic * Math.cos(radlat) * Math.PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new double[]{mglng, mglat};
    }

    public static double[] gcj02ToWgs84(double lng, double lat) {
        if (CoordTransform.outOfChina(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dlat = CoordTransform.transformLat(lng - 105.0, lat - 35.0);
        double dlng = CoordTransform.transformLng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (6335552.717000426 / (magic * sqrtmagic) * Math.PI);
        dlng = dlng * 180.0 / (6378245.0 / sqrtmagic * Math.cos(radlat) * Math.PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new double[]{lng * 2.0 - mglng, lat * 2.0 - mglat};
    }

    public static boolean outOfChina(double lng, double lat) {
        return !(lng > 73.66 && lng < 135.05 && lat > 3.86 && lat < 53.55);
    }
}

