/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.tile;

import cn.gtmap.gtcc.gis.core.geo.BoundingBox;
import cn.gtmap.gtcc.gis.core.tile.Grid;
import cn.gtmap.gtcc.gis.core.tile.GridCoverage;
import cn.gtmap.gtcc.gis.core.tile.GridSet;
import cn.gtmap.gtcc.gis.core.tile.GridSubSet;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class GridSubSetFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public GridSubSet createGridSubSet(GridSet gridSet) {
        GridSubSet ret = this.createGridSubSet(gridSet, gridSet.getOriginalExtent(), 0, gridSet.getGridLevels().length - 1);
        return ret;
    }

    public GridSubSet createGridSubSet(GridSet gridSet, BoundingBox extent, Integer zoomStart, Integer zoomStop) {
        Assert.notNull((Object)gridSet, (String)"gridSet is null");
        Grid[] gridLevels = gridSet.getGridLevels();
        int maxLevel = gridLevels.length - 1;
        if (zoomStart == null) {
            zoomStart = 0;
        }
        if (zoomStop == null) {
            zoomStop = maxLevel;
        } else if (zoomStop > maxLevel) {
            this.logger.warn("Requested to create GridSubSet with zoomStop " + zoomStop + " for GridSet " + gridSet.getName() + " whose max zoom level is " + maxLevel + ". Limiting GridSubSet to zoomStop = " + maxLevel);
            zoomStop = maxLevel;
        }
        TreeMap<Integer, GridCoverage> coverages = new TreeMap<Integer, GridCoverage>();
        for (int z = zoomStart.intValue(); z <= zoomStop; ++z) {
            long[] coverage;
            Grid level = gridLevels[z];
            if (extent == null) {
                long maxColX = level.getNumWideTiles() - 1L;
                long maxColY = level.getNumHighTiles() - 1L;
                coverage = new long[]{0L, 0L, maxColX, maxColY, z};
            } else {
                coverage = gridSet.closestRectangle(z, extent);
            }
            GridCoverage gridCov = new GridCoverage(coverage);
            coverages.put(z, gridCov);
        }
        BoundingBox originalExtent = extent;
        boolean fullCoverage = false;
        BoundingBox gridSetBounds = gridSet.getBounds();
        if (extent == null || extent.contains(gridSetBounds)) {
            fullCoverage = true;
            originalExtent = gridSetBounds;
        }
        GridSubSet ret = new GridSubSet(gridSet, originalExtent, coverages, zoomStart, zoomStop);
        return ret;
    }
}

