/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.tile;

import cn.gtmap.gtcc.gis.core.geo.BoundingBox;
import cn.gtmap.gtcc.gis.core.tile.Grid;
import cn.gtmap.gtcc.gis.core.tile.GridCoverage;
import cn.gtmap.gtcc.gis.core.tile.GridMismatchException;
import cn.gtmap.gtcc.gis.core.tile.GridSet;
import cn.gtmap.gtcc.gis.core.tile.OutsideCoverageException;
import java.util.Collections;
import java.util.Map;

public class GridSubSet {
    private final GridSet gridSet;
    private final BoundingBox extent;
    private final Map<Integer, GridCoverage> gridCoverageLevels;
    private final int minZoomLevel;
    private final int maxZoomLevel;

    public GridSubSet(GridSet gridSet, BoundingBox extent, Map<Integer, GridCoverage> gridCoverageLevels, int minZoomLevel, int maxZoomLevel) {
        this.gridSet = gridSet;
        this.extent = extent;
        this.gridCoverageLevels = gridCoverageLevels;
        this.minZoomLevel = minZoomLevel;
        this.maxZoomLevel = maxZoomLevel;
    }

    public BoundingBox boundsFromIndex(long[] tileIndex) {
        return this.gridSet.boundsFromIndex(tileIndex);
    }

    public BoundingBox boundsFromRectangle(long[] rectangleExtent) {
        return this.gridSet.boundsFromRectangle(rectangleExtent);
    }

    public long[] closestIndex(BoundingBox tileBounds) throws GridMismatchException {
        return this.gridSet.closestIndex(tileBounds);
    }

    public long[] closestRectangle(BoundingBox rectangleBounds) {
        return this.gridSet.closestRectangle(rectangleBounds);
    }

    public long[] getCoverage(int level) {
        GridCoverage coverage = this.gridCoverageLevels.get(level);
        if (coverage == null) {
            return null;
        }
        return coverage.coverage;
    }

    public long[][] getCoverages() {
        long[][] ret = new long[this.gridCoverageLevels.size()][5];
        int level = this.minZoomLevel;
        int i = 0;
        while (level <= this.maxZoomLevel) {
            long[] cov = this.getCoverage(level);
            ret[i] = cov;
            ++level;
            ++i;
        }
        return ret;
    }

    public double getDotsPerInch() {
        return 0.0254 / this.gridSet.getPixelSize();
    }

    public BoundingBox getCoverageBounds(int level) {
        long[] coverage = this.getCoverage(level);
        return this.gridSet.boundsFromRectangle(coverage);
    }

    public void checkCoverage(long[] index) throws OutsideCoverageException {
        if (this.covers(index)) {
            return;
        }
        if (index[2] < (long)this.getZoomStart() || index[2] > (long)this.getZoomStop()) {
            throw new OutsideCoverageException(index, this.getZoomStart(), this.getZoomStop());
        }
        long[] coverage = this.getCoverage((int)index[2]);
        throw new OutsideCoverageException(index, coverage);
    }

    public boolean covers(long[] index) {
        int level = (int)index[2];
        long[] coverage = this.getCoverage(level);
        if (coverage == null) {
            return false;
        }
        return index[0] >= coverage[0] && index[0] <= coverage[2] && index[1] >= coverage[1] && index[1] <= coverage[3];
    }

    public long[][] expandToMetaFactors(long[][] coverages, int[] metaFactors) {
        long[][] ret;
        for (long[] cov : ret = this.arrayDeepCopy(coverages)) {
            int z = (int)cov[4];
            Grid grid = this.gridSet.getGrid(z);
            long numTilesWide = grid.getNumWideTiles();
            long numTilesHigh = grid.getNumHighTiles();
            cov[0] = cov[0] - cov[0] % (long)metaFactors[0];
            cov[1] = cov[1] - cov[1] % (long)metaFactors[1];
            cov[2] = cov[2] - cov[2] % (long)metaFactors[0] + (long)(metaFactors[0] - 1);
            if (cov[2] > numTilesWide) {
                cov[2] = numTilesWide;
            }
            cov[3] = cov[3] - cov[3] % (long)metaFactors[1] + (long)(metaFactors[1] - 1);
            if (cov[3] <= numTilesHigh) continue;
            cov[3] = numTilesHigh;
        }
        return ret;
    }

    public int getZoomStart() {
        Integer firstLevel = Collections.min(this.gridCoverageLevels.keySet());
        return firstLevel;
    }

    public int getZoomStop() {
        Integer maxLevel = Collections.max(this.gridCoverageLevels.keySet());
        return maxLevel;
    }

    private long[][] arrayDeepCopy(long[][] array) {
        long[][] ret = new long[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, ret[i], 0, array[i].length);
        }
        return ret;
    }

    public GridSet getGridSet() {
        return this.gridSet;
    }

    public BoundingBox getExtent() {
        return this.extent;
    }

    public int getMinZoomLevel() {
        return this.minZoomLevel;
    }

    public int getMaxZoomLevel() {
        return this.maxZoomLevel;
    }
}

