/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.tile;

import cn.gtmap.gtcc.gis.core.geo.BoundingBox;
import cn.gtmap.gtcc.gis.core.geo.SRS;
import cn.gtmap.gtcc.gis.core.tile.Grid;
import cn.gtmap.gtcc.gis.core.tile.GridSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class GridSetFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final double DEFAULT_PIXEL_SIZE_METER = 2.8E-4;
    public static int DEFAULT_LEVELS = 22;
    public static final double EPSG4326_TO_METERS = 111319.49079327358;
    public static final double EPSG4490_TO_METERS = 111319.49079327358;
    public static final double EPSG3857_TO_METERS = 1.0;

    private GridSet baseGridSet(String name, SRS srs, int tileWidth, int tileHeight) {
        GridSet gridSet = new GridSet();
        gridSet.setName(name);
        gridSet.setSrs(srs);
        gridSet.setTileWidth(tileWidth);
        gridSet.setTileHeight(tileHeight);
        return gridSet;
    }

    public GridSet createGridSet(String name, SRS srs, BoundingBox extent, boolean alignTopLeft, double[] resolutions, double[] scaleDenoms, Double metersPerUnit, double pixelSize, String[] scaleNames, int tileWidth, int tileHeight, boolean yCoordinateFirst) {
        int i;
        Assert.notNull((Object)name, (String)"name is null");
        Assert.notNull((Object)srs, (String)"srs is null");
        Assert.notNull((Object)extent, (String)"extent is null");
        Assert.isTrue((!extent.isNull() && extent.isSane() ? 1 : 0) != 0, (String)("Extent is invalid: " + extent));
        Assert.isTrue((resolutions != null || scaleDenoms != null ? 1 : 0) != 0);
        Assert.isTrue((resolutions == null || scaleDenoms == null ? 1 : 0) != 0, (String)"Only one of resolutions or scaleDenoms should be provided, not both");
        for (i = 1; resolutions != null && i < resolutions.length; ++i) {
            if (!(resolutions[i] >= resolutions[i - 1])) continue;
            throw new IllegalArgumentException("Each resolution should be lower than it's prior one. Res[" + i + "] == " + resolutions[i] + ", Res[" + (i - 1) + "] == " + resolutions[i - 1] + ".");
        }
        for (i = 1; scaleDenoms != null && i < scaleDenoms.length; ++i) {
            if (!(scaleDenoms[i] >= scaleDenoms[i - 1])) continue;
            throw new IllegalArgumentException("Each scale denominator should be lower than it's prior one. Scale[" + i + "] == " + scaleDenoms[i] + ", Scale[" + (i - 1) + "] == " + scaleDenoms[i - 1] + ".");
        }
        GridSet gridSet = this.baseGridSet(name, srs, tileWidth, tileHeight);
        gridSet.setPixelSize(pixelSize);
        gridSet.setOriginalExtent(extent);
        gridSet.setyBaseToggle(alignTopLeft);
        gridSet.setyCoordinateFirst(yCoordinateFirst);
        if (metersPerUnit == null) {
            if (srs.equals(SRS.EPSG_4326)) {
                gridSet.setMetersPerUnit(111319.49079327358);
            } else if (srs.equals(SRS.EPSG_4490)) {
                gridSet.setMetersPerUnit(111319.49079327358);
            } else if (srs.equals(SRS.EPSG_3857)) {
                gridSet.setMetersPerUnit(1.0);
            } else {
                if (resolutions == null) {
                    this.logger.warn("GridSet " + name + " was defined without metersPerUnit, assuming 1m/unit." + " All scales will be off if this is incorrect.");
                } else {
                    this.logger.warn("GridSet " + name + " was defined without metersPerUnit. " + "Assuming 1m per SRS unit for WMTS scale output.");
                }
                gridSet.setMetersPerUnit(1.0);
            }
        } else {
            gridSet.setMetersPerUnit(metersPerUnit);
        }
        if (resolutions == null) {
            gridSet.setGridLevels(new Grid[scaleDenoms.length]);
        } else {
            gridSet.setGridLevels(new Grid[resolutions.length]);
        }
        for (int i2 = 0; i2 < gridSet.getGridLevels().length; ++i2) {
            Grid curGrid = new Grid();
            if (scaleDenoms != null) {
                curGrid.setScale(scaleDenoms[i2]);
                curGrid.setResolution(pixelSize * (scaleDenoms[i2] / gridSet.getMetersPerUnit()));
            } else {
                curGrid.setResolution(resolutions[i2]);
                curGrid.setScale(resolutions[i2] * gridSet.getMetersPerUnit() / 2.8E-4);
            }
            double mapUnitWidth = (double)tileWidth * curGrid.getResolution();
            double mapUnitHeight = (double)tileHeight * curGrid.getResolution();
            long tilesWide = (long)Math.ceil((extent.getWidth() - mapUnitWidth * 0.01) / mapUnitWidth);
            long tilesHigh = (long)Math.ceil((extent.getHeight() - mapUnitHeight * 0.01) / mapUnitHeight);
            curGrid.setNumWideTiles(tilesWide);
            curGrid.setNumHighTiles(tilesHigh);
            if (scaleNames == null || scaleNames[i2] == null) {
                curGrid.setName(gridSet.getName() + ":" + i2);
            } else {
                curGrid.setName(scaleNames[i2]);
            }
            gridSet.getGridLevels()[i2] = curGrid;
        }
        return gridSet;
    }

    public GridSet createGridSet(String name, SRS srs, BoundingBox extent, boolean alignTopLeft, int levels, Double metersPerUnit, double pixelSize, int tileWidth, int tileHeight, boolean yCoordinateFirst) {
        int tilesHigh;
        int tilesWide;
        double extentHeight;
        double resY;
        double extentWidth = extent.getWidth();
        double resX = extentWidth / (double)tileWidth;
        if (resX <= (resY = (extentHeight = extent.getHeight()) / (double)tileHeight)) {
            tilesWide = 1;
            tilesHigh = (int)Math.round(resY / resX);
            resY /= (double)tilesHigh;
        } else {
            tilesHigh = 1;
            tilesWide = (int)Math.round(resX / resY);
            resX /= (double)tilesWide;
        }
        double res = Math.max(resX, resY);
        double adjustedExtentWidth = (double)(tilesWide * tileWidth) * res;
        double adjustedExtentHeight = (double)(tilesHigh * tileHeight) * res;
        BoundingBox adjExtent = new BoundingBox(extent);
        adjExtent.setxMax(adjExtent.getxMin() + adjustedExtentWidth);
        if (alignTopLeft) {
            adjExtent.setyMin(adjExtent.getyMax() - adjustedExtentHeight);
        } else {
            adjExtent.setyMax(adjExtent.getyMin() + adjustedExtentHeight);
        }
        double[] resolutions = new double[levels];
        resolutions[0] = res;
        for (int i = 1; i < levels; ++i) {
            resolutions[i] = resolutions[i - 1] / 2.0;
        }
        return this.createGridSet(name, srs, adjExtent, alignTopLeft, resolutions, null, metersPerUnit, pixelSize, null, tileWidth, tileHeight, yCoordinateFirst);
    }
}

