/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.tile;

import cn.gtmap.gtcc.gis.core.geo.BoundingBox;
import cn.gtmap.gtcc.gis.core.geo.SRS;
import cn.gtmap.gtcc.gis.core.tile.Grid;
import cn.gtmap.gtcc.gis.core.tile.GridAlignmentMismatchException;
import cn.gtmap.gtcc.gis.core.tile.GridMismatchException;
import cn.gtmap.gtcc.gis.core.tile.ResolutionMismatchException;
import java.io.Serializable;

public class GridSet
implements Serializable {
    private String name;
    private int tileWidth;
    private int tileHeight;
    private SRS srs;
    private BoundingBox originalExtent;
    private Grid[] gridLevels;
    private double metersPerUnit;
    private double pixelSize;
    private boolean yBaseToggle = false;
    private boolean yCoordinateFirst = false;
    private String desc;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public SRS getSrs() {
        return this.srs;
    }

    public void setSrs(SRS srs) {
        this.srs = srs;
    }

    public BoundingBox getOriginalExtent() {
        return this.originalExtent;
    }

    public void setOriginalExtent(BoundingBox originalExtent) {
        this.originalExtent = originalExtent;
    }

    public Grid[] getGridLevels() {
        return this.gridLevels;
    }

    public void setGridLevels(Grid[] gridLevels) {
        this.gridLevels = gridLevels;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public double getMetersPerUnit() {
        return this.metersPerUnit;
    }

    public void setMetersPerUnit(double metersPerUnit) {
        this.metersPerUnit = metersPerUnit;
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    public void setPixelSize(double pixelSize) {
        this.pixelSize = pixelSize;
    }

    public boolean isyBaseToggle() {
        return this.yBaseToggle;
    }

    public void setyBaseToggle(boolean yBaseToggle) {
        this.yBaseToggle = yBaseToggle;
    }

    public boolean isyCoordinateFirst() {
        return this.yCoordinateFirst;
    }

    public void setyCoordinateFirst(boolean yCoordinateFirst) {
        this.yCoordinateFirst = yCoordinateFirst;
    }

    public Grid getGrid(int level) {
        return this.gridLevels[level];
    }

    public double[] tileOrigin() {
        BoundingBox extent = this.getOriginalExtent();
        double[] tileOrigin = new double[]{extent.getxMin(), this.yBaseToggle ? extent.getyMax() : extent.getyMin()};
        return tileOrigin;
    }

    public BoundingBox boundsFromIndex(long[] tileIndex) {
        int tileZ = (int)tileIndex[2];
        Grid grid = this.getGrid(tileZ);
        long tileX = tileIndex[0];
        long tileY = this.yBaseToggle ? tileIndex[1] - grid.getNumHighTiles() : tileIndex[1];
        double width = grid.getResolution() * (double)this.getTileWidth();
        double height = grid.getResolution() * (double)this.getTileHeight();
        double[] tileOrigin = this.tileOrigin();
        BoundingBox tileBounds = new BoundingBox(tileOrigin[0] + width * (double)tileX, tileOrigin[1] + height * (double)tileY, tileOrigin[0] + width * (double)(tileX + 1L), tileOrigin[1] + height * (double)(tileY + 1L));
        return tileBounds;
    }

    public BoundingBox boundsFromRectangle(long[] rectangleExtent) {
        Grid grid = this.getGrid((int)rectangleExtent[4]);
        double width = grid.getResolution() * (double)this.getTileWidth();
        double height = grid.getResolution() * (double)this.getTileHeight();
        long bottomY = rectangleExtent[1];
        long topY = rectangleExtent[3];
        if (this.yBaseToggle) {
            bottomY -= grid.getNumHighTiles();
            topY -= grid.getNumWideTiles();
        }
        double[] tileOrigin = this.tileOrigin();
        double minx = tileOrigin[0] + width * (double)rectangleExtent[0];
        double miny = tileOrigin[1] + height * (double)bottomY;
        double maxx = tileOrigin[0] + width * (double)(rectangleExtent[2] + 1L);
        double maxy = tileOrigin[1] + height * (double)(topY + 1L);
        return new BoundingBox(minx, miny, maxx, maxy);
    }

    public long[] closestRectangle(int level, BoundingBox rectangleBounds) {
        Grid grid = this.getGrid(level);
        double width = grid.getResolution() * (double)this.getTileWidth();
        double height = grid.getResolution() * (double)this.getTileHeight();
        double[] tileOrign = this.tileOrigin();
        long minX = (long)Math.floor((rectangleBounds.getxMin() - tileOrign[0]) / width);
        long minY = (long)Math.floor((rectangleBounds.getyMin() - tileOrign[1]) / height);
        long maxX = (long)Math.ceil((rectangleBounds.getxMax() - tileOrign[0]) / width);
        long maxY = (long)Math.ceil((rectangleBounds.getyMax() - tileOrign[1]) / height);
        if (this.yBaseToggle) {
            minY += grid.getNumHighTiles();
            maxY += grid.getNumHighTiles();
        }
        long[] ret = new long[]{minX, minY, maxX - 1L, maxY - 1L, level};
        return ret;
    }

    public long[] closestRectangle(BoundingBox rectangleBounds) {
        double rectWidth = rectangleBounds.getWidth();
        double rectHeight = rectangleBounds.getHeight();
        double bestError = Double.MAX_VALUE;
        int bestLevel = -1;
        for (int i = 0; i < this.getGridLevels().length; ++i) {
            Grid grid = this.getGrid(i);
            double countX = rectWidth / (grid.getResolution() * (double)this.getTileWidth());
            double countY = rectHeight / (grid.getResolution() * (double)this.getTileHeight());
            double error = Math.abs(countX - (double)Math.round(countX)) + Math.abs(countY - (double)Math.round(countY));
            if (error < bestError) {
                bestError = error;
                bestLevel = i;
                continue;
            }
            if (error >= bestError) break;
        }
        return this.closestRectangle(bestLevel, rectangleBounds);
    }

    protected long[] closestIndex(BoundingBox tileBounds) throws GridMismatchException {
        Grid grid;
        double error;
        double wRes = tileBounds.getWidth() / (double)this.getTileWidth();
        double bestError = Double.MAX_VALUE;
        int bestLevel = -1;
        double bestResolution = -1.0;
        int i = 0;
        while (i < this.getGridLevels().length && (error = Math.abs(wRes - (grid = this.getGrid(i)).getResolution())) < bestError) {
            bestError = error;
            bestResolution = grid.getResolution();
            bestLevel = i++;
        }
        if (Math.abs(wRes - bestResolution) > 0.1 * wRes) {
            throw new ResolutionMismatchException(wRes, bestResolution);
        }
        return this.closestIndex(bestLevel, tileBounds);
    }

    protected long[] closestIndex(int level, BoundingBox tileBounds) throws GridAlignmentMismatchException {
        Grid grid = this.getGrid(level);
        double width = grid.getResolution() * (double)this.getTileWidth();
        double height = grid.getResolution() * (double)this.getTileHeight();
        double x = (tileBounds.getxMin() - this.tileOrigin()[0]) / width;
        double y = (tileBounds.getyMin() - this.tileOrigin()[1]) / height;
        long posX = Math.round(x);
        long posY = Math.round(y);
        if (Math.abs(x - (double)posX) > 0.1 || Math.abs(y - (double)posY) > 0.1) {
            throw new GridAlignmentMismatchException(x, posX, y, posY);
        }
        if (this.yBaseToggle) {
            posY += grid.getNumHighTiles();
        }
        long[] ret = new long[]{posX, posY, level};
        return ret;
    }

    public BoundingBox getBounds() {
        long tilesHigh;
        long tilesWide;
        int i;
        for (i = this.getGridLevels().length - 1; i > 0; --i) {
            tilesWide = this.getGrid(i).getNumWideTiles();
            tilesHigh = this.getGrid(i).getNumHighTiles();
            if (tilesWide == 1L && tilesHigh == 0L) break;
        }
        tilesWide = this.getGrid(i).getNumWideTiles();
        tilesHigh = this.getGrid(i).getNumHighTiles();
        long[] ret = new long[]{0L, 0L, tilesWide - 1L, tilesHigh - 1L, i};
        return this.boundsFromRectangle(ret);
    }
}

