/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.tile;

import cn.gtmap.gtcc.gis.core.geo.BoundingBox;
import cn.gtmap.gtcc.gis.core.geo.SRS;
import cn.gtmap.gtcc.gis.core.tile.GridSet;
import cn.gtmap.gtcc.gis.core.tile.GridSetFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultGridSets {
    public final GridSet GS_4326;
    public final GridSet GS_4490;
    public final GridSet GS_3857;
    private Map<String, GridSet> gridSets;
    private Set<String> embeddedGridSets;
    private GridSetFactory gridSetFactory;

    public DefaultGridSets(GridSetFactory gridSetFactory) {
        this.gridSetFactory = gridSetFactory;
        this.gridSets = new ConcurrentHashMap<String, GridSet>();
        this.GS_4326 = gridSetFactory.createGridSet("EPSG:4326", SRS.EPSG_4326, BoundingBox.EPSG_4326_BBOX, false, GridSetFactory.DEFAULT_LEVELS, null, 2.8E-4, 256, 256, true);
        this.gridSets.put(this.GS_4326.getName(), this.GS_4326);
        this.GS_3857 = gridSetFactory.createGridSet("EPSG:3857", SRS.EPSG_3857, BoundingBox.EPSG_3857_BBOX, false, this.commonPractice900913Resolutions(), null, 1.0, 2.8E-4, null, 256, 256, false);
        this.gridSets.put(this.GS_3857.getName(), this.GS_3857);
        GridSet globalCRS84Pixel = gridSetFactory.createGridSet("GlobalCRS84Pixel", SRS.EPSG_4326, BoundingBox.EPSG_4326_BBOX, true, this.scalesCRS84PixelResolutions(), null, null, 2.8E-4, null, 256, 256, true);
        this.gridSets.put(globalCRS84Pixel.getName(), globalCRS84Pixel);
        GridSet globalCRS84Scale = gridSetFactory.createGridSet("GlobalCRS84Scale", SRS.EPSG_4326, BoundingBox.EPSG_4326_BBOX, true, null, this.scalesCRS84ScaleDenominators(), null, 2.8E-4, null, 256, 256, true);
        this.gridSets.put(globalCRS84Scale.getName(), globalCRS84Scale);
        GridSet googleCRS84Quad = gridSetFactory.createGridSet("GoogleCRS84Quad", SRS.EPSG_4326, BoundingBox.EPSG_4326_BBOX, true, null, this.scalesCRS84QuadScaleDenominators(), null, 2.8E-4, null, 256, 256, true);
        this.gridSets.put(googleCRS84Quad.getName(), googleCRS84Quad);
        this.GS_4490 = gridSetFactory.createGridSet("TDTCGCS2000", SRS.EPSG_4490, BoundingBox.EPSG_4490_BBOX, true, this.cgcs2000Resolutions(), null, null, 2.8E-4, null, 256, 256, true);
        this.gridSets.put(this.GS_4490.getName(), this.GS_4490);
        this.embeddedGridSets = Collections.unmodifiableSet(new HashSet<String>(this.gridSets.keySet()));
    }

    public void put(GridSet gridSet) {
        if (this.gridSets.containsKey(gridSet.getName())) {
            this.gridSets.remove(gridSet.getName());
        }
        this.gridSets.put(gridSet.getName(), gridSet);
    }

    public Map<String, GridSet> getGridSets() {
        return this.gridSets;
    }

    private double[] commonPractice900913Resolutions() {
        return new double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125, 9783.939619140625, 4891.9698095703125, 2445.9849047851562, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135, 0.29858214169740677, 0.14929107084870338, 0.07464553542435169, 0.037322767712175846, 0.018661383856087923, 0.009330691928043961, 0.004665345964021981, 0.0023326729820109904, 0.0011663364910054952, 5.831682455027476E-4, 2.915841227513738E-4, 1.457920613756869E-4};
    }

    private double[] scalesCRS84PixelResolutions() {
        double[] scalesCRS84Pixel;
        scalesCRS84Pixel = new double[]{2.0, 1.0, 0.5, scalesCRS84Pixel[2] * 0.6666666666666666, scalesCRS84Pixel[2] / 3.0, scalesCRS84Pixel[4] / 2.0, scalesCRS84Pixel[4] / 5.0, scalesCRS84Pixel[4] / 10.0, 0.008333333333333333, scalesCRS84Pixel[8] / 2.0, scalesCRS84Pixel[9] / 3.0, scalesCRS84Pixel[9] / 5.0, scalesCRS84Pixel[11] / 3.0, scalesCRS84Pixel[12] / 2.0, scalesCRS84Pixel[13] * 0.6, scalesCRS84Pixel[14] / 3.0, scalesCRS84Pixel[15] * 0.3, scalesCRS84Pixel[16] / 3.0};
        return scalesCRS84Pixel;
    }

    private double[] scalesCRS84ScaleDenominators() {
        double[] scalesCRS84Pixel = new double[]{5.0E8, 2.5E8, 1.0E8, 5.0E7, 2.5E7, 1.0E7, 5000000.0, 2500000.0, 1000000.0, 500000.0, 250000.0, 100000.0, 50000.0, 25000.0, 10000.0, 5000.0, 2500.0, 1000.0, 500.0, 250.0, 100.0};
        return scalesCRS84Pixel;
    }

    private double[] scalesCRS84QuadScaleDenominators() {
        double[] scalesCRS84QuadScaleResolutions = new double[]{5.590822640287178E8, 2.795411320143589E8, 1.397705660071794E8, 6.988528300358972E7, 3.494264150179486E7, 1.747132075089743E7, 8735660.375448715, 4367830.187724357, 2183915.093862179, 1091957.546931089, 545978.7734655447, 272989.3867327723, 136494.6933663862, 68247.34668319309, 34123.67334159654, 17061.83667079827, 8530.918335399136, 4265.459167699568, 2132.729583849784};
        return scalesCRS84QuadScaleResolutions;
    }

    private double[] scalesCGCS2000ScaleDenominators() {
        return new double[]{5.90995197141668E8, 2.95497598570834E8, 1.47748799285417E8, 7.38743996427087E7, 3.69371998213544E7, 1.84685999106772E7, 9234299.95533859, 4617149.97766929, 2308574.98883465, 1154287.49441732, 577143.747208662, 288571.873604331, 144285.936802165, 72142.9684010827, 36071.4842005414, 18035.7421002707, 9017.87105013534, 4508.93552506767, 2254.46776253384, 1127.23388126692, 563.61694063346};
    }

    private double[] cgcs2000Resolutions() {
        return new double[]{1.4062500262315776, 0.7031250131157888, 0.3515625065578944, 0.1757812532789477, 0.08789062663947395, 0.04394531331973697, 0.021972656659868466, 0.010986328329934222, 0.005493164164967122, 0.0027465820824835495, 0.0013732910412417793, 6.866455206208897E-4, 3.433227603104437E-4, 1.716613801552223E-4, 8.583069007761127E-5, 4.291534503880564E-5, 2.1457672519402795E-5, 1.0728836259701398E-5, 5.364418129850711E-6, 2.6822090649253553E-6, 1.3411045324626777E-6};
    }

    public Set<String> getEmbeddedGridSets() {
        return this.embeddedGridSets;
    }
}

