/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.jtsgeo;

import cn.gtmap.gtcc.gis.core.agsgeo.AgsGeometryHelper;
import cn.gtmap.gtcc.gis.core.analyze.ex.GeometryServiceException;
import cn.gtmap.gtcc.gis.core.exception.GeometryException;
import cn.gtmap.gtcc.gis.core.util.GeometryUtils;
import cn.gtmap.gtcc.gis.core.util.SRTransformations;
import cn.gtmap.gtcc.support.Document;
import cn.gtmap.gtcc.utils.FileUtil;
import cn.gtmap.gtcc.utils.UUIDGenerator;
import cn.gtmap.gtcc.utils.Utils;
import cn.gtmap.gtcc.utils.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.SpatialReference;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JTSGeometryHelper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OperatorFactoryLocal operatorFactory = OperatorFactoryLocal.getInstance();
    private static final String DEFAULT_LAYER_REGION_FIELD = "DEFAULTLAYER";
    private GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    private double simplifyTolerance;
    private Map<String, String> regionLayers;
    private Map regionSet;
    private CoordinateReferenceSystem defaultCrs;
    static final String EPSG = "EPSG";
    static final String SHAPE = "SHAPE";
    static final String GEOMETRY = "geometry";
    static final String FEATURE_CRS = "crs";
    static final String FEATURE = "feature";
    static final String SHAPEFILE = "shapefile";
    private final String METADATA = "METADATA";
    private final String DEFAULT_DELIMITER = ",";
    public static final double SIMPLIFY_TOLERANCE = 1.0E-9;
    public static GeometryFactory factory = JTSFactoryFinder.getGeometryFactory();

    public CoordinateReferenceSystem getSeLayerCRS(SeLayer layer) {
        return this.getCRSByWKTString(layer.getCoordRef().getCoordSysDescription());
    }

    public CoordinateReferenceSystem getCRSByWKTString(String wktCRS) {
        try {
            return CRS.parseWKT((String)this.removeMETA(SRTransformations.getCoordinateSystem(wktCRS).toString()));
        }
        catch (Exception e) {
            throw new GeometryException(GeometryException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
        catch (PeProjectionException e) {
            throw new GeometryException(GeometryException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    private String removeMETA(String wkt) {
        if (StringUtils.isNotEmpty((String)wkt) && wkt.contains("METADATA")) {
            int index = wkt.indexOf("METADATA");
            int rindex = wkt.indexOf("]", index);
            String lstr = wkt.substring(0, index).trim();
            if (lstr.endsWith(",")) {
                lstr = lstr.substring(0, lstr.length() - 1);
            }
            String rstr = wkt.substring(rindex + 1, wkt.length()).trim();
            return lstr + rstr;
        }
        return wkt;
    }

    public CoordinateReferenceSystem parseUndefineSR(String value) {
        try {
            int srid = Integer.parseInt(value);
            if (srid != 0) {
                return this.getCRSBySRID(value);
            }
        }
        catch (NumberFormatException e) {
            if (value.indexOf(EPSG) == 0) {
                return this.getCRSBySRID(value.substring(EPSG.length() + 1, value.length()));
            }
            return this.getCRSByWKTString(value);
        }
        catch (Exception e) {
            CoordinateReferenceSystem ret = null;
            if (value.indexOf(EPSG) != 0) {
                String epsg = EPSG.concat(":" + value);
                ret = this.getCRSByCommnonString(epsg);
            }
            if (Utils.isNotNull(ret)) {
                return ret;
            }
            throw new GeometryException(GeometryException.ExceptionType.CRS_PARSE_EXCEPTION, value);
        }
        return null;
    }

    public CoordinateReferenceSystem getCRSByCommnonString(String crs) {
        try {
            return CRS.decode((String)crs, (boolean)true);
        }
        catch (Exception e) {
            throw new GeometryException(GeometryException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getCRSBySRID(String srid) {
        try {
            CoordinateReferenceSystem crs = this.getCRSByCommnonString(EPSG.concat(":" + srid));
            if (crs != null) {
                return crs;
            }
            PeCoordinateSystem peCoordinateSystem = SRTransformations.getCoordinateSystem(Integer.valueOf(srid));
            if (peCoordinateSystem != null) {
                return this.getCRSByWKTString(peCoordinateSystem.toString());
            }
            return null;
        }
        catch (PeProjectionException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public com.vividsolutions.jts.geom.Geometry readWKT(String wkt) throws GeometryException {
        try {
            return new WKTReader(this.geometryFactory).read(wkt);
        }
        catch (Exception e) {
            throw new GeometryException(GeometryException.ExceptionType.WKT_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public com.vividsolutions.jts.geom.Geometry project(com.vividsolutions.jts.geom.Geometry geometry, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws GeometryException {
        return this.projectByAGS(geometry, sourceCRS, targetCRS);
    }

    public com.vividsolutions.jts.geom.Geometry projectByAGS(com.vividsolutions.jts.geom.Geometry geometry, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        try {
            return SRTransformations.project(geometry, sourceCRS.toWKT(), targetCRS.toWKT());
        }
        catch (PeProjectionException e) {
            throw new GeometryException(GeometryException.ExceptionType.PROJECT_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public String project(String geometry, String inSR, String outSR) {
        Object geo = this.readUnTypeGeoJSON(geometry);
        CoordinateReferenceSystem in = this.parseUndefineSR(inSR);
        CoordinateReferenceSystem out = this.parseUndefineSR(outSR);
        if (geo instanceof com.vividsolutions.jts.geom.Geometry) {
            com.vividsolutions.jts.geom.Geometry g = this.project((com.vividsolutions.jts.geom.Geometry)geo, in, out);
            return this.toGeoJSON(g);
        }
        if (geo instanceof FeatureCollection || geo instanceof SimpleFeature) {
            Object feature = this.project(geo, in, out);
            return this.toGeoJSON(feature);
        }
        throw new GeometryServiceException(GeometryServiceException.ExceptionType.PROJECT_EXCEPTION, "geometry type not be supported, maybe GeometryCollection");
    }

    public com.vividsolutions.jts.geom.Geometry simplify(com.vividsolutions.jts.geom.Geometry geometry, double tolerance) {
        return geometry.isValid() && geometry.isSimple() ? geometry : DouglasPeuckerSimplifier.simplify((com.vividsolutions.jts.geom.Geometry)geometry, (double)tolerance);
    }

    public Object readUnTypeGeoJSON(String geoJSON) {
        return GeometryUtils.parseGeoJSON(geoJSON);
    }

    public TopologyValidationError validGeometry(com.vividsolutions.jts.geom.Geometry geometry) {
        IsValidOp isValidOp = new IsValidOp(geometry);
        return isValidOp.getValidationError();
    }

    public TopologyValidationError validGeometry(com.vividsolutions.jts.geom.Geometry geometry, boolean esriFlag) {
        IsValidOp isValidOp = new IsValidOp(geometry);
        isValidOp.setSelfTouchingRingFormingHoleValid(esriFlag);
        return isValidOp.getValidationError();
    }

    public boolean validGeometry(String wktGeometry, Object sr) {
        try {
            Geometry geo = GeometryEngine.geometryFromWkt((String)wktGeometry, (int)0, (Geometry.Type)Geometry.Type.Unknown);
            OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
            OperatorSimplify operatorSimplify = (OperatorSimplify)factory.getOperator(Operator.Type.Simplify);
            SpatialReference targetSr = sr instanceof String ? SpatialReference.create((String)String.valueOf(sr)) : SpatialReference.create((int)Integer.valueOf(String.valueOf(sr)));
            return operatorSimplify.isSimpleAsFeature(geo, targetSr, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public com.vividsolutions.jts.geom.Geometry forceSimplify(com.vividsolutions.jts.geom.Geometry geometry, double tolerance) {
        return DouglasPeuckerSimplifier.simplify((com.vividsolutions.jts.geom.Geometry)geometry, (double)tolerance);
    }

    public String toFeatureJSON(Object feature) {
        try {
            FeatureJSON featureJSON = new FeatureJSON(new GeometryJSON(14));
            StringWriter out = new StringWriter();
            if (feature instanceof SimpleFeature) {
                featureJSON.setEncodeFeatureBounds(((SimpleFeature)feature).getBounds() != null);
                featureJSON.setEncodeFeatureCRS(((SimpleFeature)feature).getFeatureType().getCoordinateReferenceSystem() != null);
                featureJSON.writeFeature((SimpleFeature)feature, (Object)out);
            } else if (feature instanceof FeatureCollection) {
                if (((FeatureCollection)feature).size() > 0) {
                    featureJSON.setEncodeFeatureCollectionBounds(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getBounds() != null);
                    featureJSON.setEncodeFeatureCollectionCRS(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getFeatureType().getCoordinateReferenceSystem() != null);
                }
                featureJSON.writeFeatureCollection((FeatureCollection)feature, (Object)out);
            } else if (feature instanceof cn.gtmap.gtcc.domain.gis.esm.FeatureCollection) {
                return ((cn.gtmap.gtcc.domain.gis.esm.FeatureCollection)feature).toJson();
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new GeometryException(GeometryException.ExceptionType.FEATURE_TO_JSON_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public FeatureCollection list2FeatureCollection(List<Map<String, Object>> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        if (value != null && value.size() > 0) {
            for (Map<String, Object> item : value) {
                try {
                    collection.add(this.map2SimpleFeature(item, srcCRS, destCRS));
                }
                catch (Exception e) {
                    this.logger.info("list.2featureCollection.false/n" + e.getLocalizedMessage());
                }
            }
        }
        return collection;
    }

    public FeatureCollection list2FeatureCollection(List<Map<String, Object>> value, CoordinateReferenceSystem destCRS) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        if (value != null && value.size() > 0) {
            for (Map<String, Object> item : value) {
                try {
                    collection.add(this.map2SimpleFeature(item, (CoordinateReferenceSystem)item.get(FEATURE_CRS), destCRS));
                }
                catch (Exception e) {
                    this.logger.info("list.2featureCollection.false/n" + e.getLocalizedMessage());
                }
            }
        }
        return collection;
    }

    public SimpleFeature map2SimpleFeature(Map<String, Object> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        String[] keys;
        SimpleFeatureType featureType;
        com.vividsolutions.jts.geom.Geometry geometry;
        com.vividsolutions.jts.geom.Geometry geometry2 = geometry = value.containsKey(SHAPE) ? this.readWKT((String)value.get(SHAPE)) : null;
        if (geometry != null && srcCRS != null && destCRS != null && !srcCRS.equals(destCRS)) {
            geometry = this.project(geometry, srcCRS, destCRS);
            featureType = this.getFeatureType(value, destCRS);
        } else {
            featureType = this.getFeatureType(value, srcCRS);
        }
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        for (String key : keys = value.keySet().toArray(new String[0])) {
            if (SHAPE.equals(key)) {
                featureBuilder.add((Object)geometry);
                continue;
            }
            if (FEATURE_CRS.equals(key)) continue;
            featureBuilder.add(value.get(key) != null ? value.get(key) : "");
        }
        return featureBuilder.buildFeature(FEATURE.concat(UUIDGenerator.generate()));
    }

    public SimpleFeatureType getFeatureType(Map<String, Object> value, CoordinateReferenceSystem crs) {
        String[] keys;
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(FEATURE);
        if (Utils.isNotNull((Object)crs)) {
            typeBuilder.setCRS(crs);
        }
        for (String key : keys = value.keySet().toArray(new String[0])) {
            if (SHAPE.equals(key)) {
                typeBuilder.add(GEOMETRY, com.vividsolutions.jts.geom.Geometry.class);
                continue;
            }
            if (FEATURE_CRS.equals(key)) continue;
            typeBuilder.add(key, value.get(key) != null ? value.get(key).getClass() : String.class);
        }
        return typeBuilder.buildFeatureType();
    }

    public File exportToShp(String geoJson, CoordinateReferenceSystem crs, String tempPath) throws Exception {
        Assert.notNull((Object)geoJson, (String)"shp.export.geo.null");
        ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
        Object geo = this.readUnTypeGeoJSON(geoJson);
        if (geo instanceof FeatureCollection) {
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                HashMap<String, Object> record = new HashMap<String, Object>(16);
                for (Property property : feature.getProperties()) {
                    if (property.getName().getLocalPart().equalsIgnoreCase(FEATURE_CRS)) continue;
                    record.put(property.getName().getLocalPart(), property.getValue());
                }
                records.add(record);
            }
        } else if (geo instanceof SimpleFeature) {
            HashMap<String, Object> record = new HashMap<String, Object>(16);
            for (Property property : ((SimpleFeature)geo).getProperties()) {
                if (property.getName().getLocalPart().equalsIgnoreCase(FEATURE_CRS)) continue;
                record.put(property.getName().getLocalPart(), property.getValue());
            }
            records.add(record);
        }
        if (records.size() == 0) {
            throw new RuntimeException("shp.export.records.null");
        }
        try {
            String folderPath = tempPath.concat(File.separator + "SHP_" + System.currentTimeMillis());
            return this.createShpZip(folderPath, records, crs);
        }
        catch (Exception ex) {
            throw new RuntimeException("shp.export.error");
        }
    }

    public File exportToShp(String geoJson, String tempPath) throws Exception {
        Assert.notNull((Object)geoJson, (String)"shp.export.geo.null");
        ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
        CoordinateReferenceSystem sourceCrs = null;
        Object geo = this.readUnTypeGeoJSON(geoJson);
        if (geo instanceof FeatureCollection) {
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                HashMap<String, Object> record = new HashMap<String, Object>();
                for (Property property : feature.getProperties()) {
                    if (property.getName().getLocalPart().equalsIgnoreCase(FEATURE_CRS)) continue;
                    record.put(property.getName().getLocalPart(), property.getValue());
                }
                records.add(record);
                if (Utils.isNull((Object)sourceCrs)) {
                    sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
                }
                if (!Utils.isNull((Object)sourceCrs)) continue;
                sourceCrs = this.readFeatureJSONCRS(this.toFeatureJSON(feature));
            }
        } else if (geo instanceof SimpleFeature) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (Property property : ((SimpleFeature)geo).getProperties()) {
                if (property.getName().getLocalPart().equalsIgnoreCase(FEATURE_CRS)) continue;
                record.put(property.getName().getLocalPart(), property.getValue());
            }
            records.add(record);
            if (Utils.isNull(sourceCrs)) {
                sourceCrs = ((SimpleFeature)geo).getFeatureType().getCoordinateReferenceSystem();
            }
        }
        if (records.size() == 0) {
            throw new RuntimeException("shp.export.records.null");
        }
        if (Utils.isNull(sourceCrs)) {
            this.logger.warn("shp.export.crs.null", this.defaultCrs == null ? null : this.defaultCrs.toWKT());
        }
        try {
            String folderPath = tempPath.concat(File.separator + "SHP_" + System.currentTimeMillis());
            return this.createShpZip(folderPath, records, sourceCrs);
        }
        catch (Exception ex) {
            throw new RuntimeException("shp.export.error:" + ex.getLocalizedMessage());
        }
    }

    public File createShpZip(String folderPath, List<Map<String, Object>> values, CoordinateReferenceSystem crs) throws IOException {
        try {
            String[] keys;
            String filePath;
            File shpFile;
            File folderFile = new File(folderPath);
            if (!folderFile.exists()) {
                folderFile.mkdir();
            }
            if (!(shpFile = new File(filePath = folderFile.getPath().concat(File.separator + folderFile.getName().concat(".".concat(Document.Type.shp.name()))))).exists()) {
                shpFile.createNewFile();
            }
            HashMap<String, URL> params = new HashMap<String, URL>(16);
            params.put(ShapefileDataStoreFactory.URLP.key, shpFile.toURI().toURL());
            ShapefileDataStore ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            Map<String, Object> value = values.get(0);
            SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
            typeBuilder.setName(SHAPEFILE);
            for (String key : keys = value.keySet().toArray(new String[0])) {
                if (SHAPE.equals(key) || GEOMETRY.equals(key)) {
                    Object geo = value.get(key);
                    if (geo instanceof String) {
                        geo = this.readWKT(MapUtils.getString(value, (Object)key));
                    }
                    if (geo instanceof Point) {
                        typeBuilder.add("the_geom", Point.class);
                        continue;
                    }
                    if (geo instanceof LineString) {
                        typeBuilder.add("the_geom", LineString.class);
                        continue;
                    }
                    if (geo instanceof Polygon) {
                        typeBuilder.add("the_geom", Polygon.class);
                        continue;
                    }
                    if (geo instanceof MultiPolygon) {
                        typeBuilder.add("the_geom", MultiPolygon.class);
                        continue;
                    }
                    if (!(geo instanceof MultiLineString)) continue;
                    typeBuilder.add("the_geom", MultiLineString.class);
                    continue;
                }
                if (key.length() > 10) {
                    String keyN = key.substring(0, 10);
                    this.logger.warn("\u5b57\u6bb5\u540d \u300e" + key + "\u300f\u957f\u5ea6\u8d85\u8fc710\u4e2a\u5b57\u7b26, \u5c06\u88ab\u622a\u53d6\u4e3a \u300e" + keyN + "\u300f");
                    typeBuilder.add(keyN, value.get(key) != null ? value.get(key).getClass() : String.class);
                    continue;
                }
                typeBuilder.add(key, value.get(key) != null ? value.get(key).getClass() : String.class);
            }
            if (Utils.isNotNull((Object)crs)) {
                typeBuilder.setCRS(crs);
            } else {
                typeBuilder.setCRS((CoordinateReferenceSystem)(this.defaultCrs == null ? DefaultGeographicCRS.WGS84 : this.defaultCrs));
            }
            ds.createSchema(typeBuilder.buildFeatureType());
            ds.forceSchemaCRS(typeBuilder.getCRS());
            ds.setCharset(Charset.forName("GBK"));
            this.logger.debug("[\u5bfc\u51fashp\u7a7a\u95f4\u53c2\u8003]:" + typeBuilder.getCRS().toWKT());
            FeatureWriter writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            SimpleFeature feature = null;
            for (Map<String, Object> item : values) {
                com.vividsolutions.jts.geom.Geometry geometry;
                feature = (SimpleFeature)writer.next();
                com.vividsolutions.jts.geom.Geometry geometry2 = geometry = item.containsKey(SHAPE) ? this.readWKT((String)item.get(SHAPE)) : null;
                if (Utils.isNull(geometry)) {
                    Object geo = item.get(GEOMETRY);
                    if (geo instanceof com.vividsolutions.jts.geom.Geometry) {
                        geometry = (com.vividsolutions.jts.geom.Geometry)geo;
                    } else if (geo instanceof String) {
                        com.vividsolutions.jts.geom.Geometry geometry3 = geometry = item.containsKey(GEOMETRY) ? this.readWKT((String)item.get(GEOMETRY)) : null;
                    }
                }
                if (Utils.isNull((Object)geometry)) continue;
                feature.setAttribute("the_geom", (Object)this.geometryFactory.createGeometry(geometry));
                for (Map.Entry<String, Object> entry : item.entrySet()) {
                    String temp;
                    String key = String.valueOf(entry.getKey());
                    Object val = entry.getValue();
                    if (key.equals(SHAPE) || key.equals(FEATURE_CRS) || key.equals(GEOMETRY) || Utils.isContainChinese((String)(temp = key.length() > 10 ? key.substring(0, 10) : key))) continue;
                    if (val instanceof String) {
                        feature.setAttribute(temp, (Object)String.valueOf(val));
                        continue;
                    }
                    if (val instanceof Double) {
                        feature.setAttribute(temp, (Object)MapUtils.getDoubleValue(item, (Object)key));
                        continue;
                    }
                    feature.setAttribute(temp, val);
                }
            }
            writer.write();
            writer.close();
            ds.dispose();
            File zipFile = ZipUtil.doZip((String)folderPath, null);
            if (zipFile.exists()) {
                return zipFile;
            }
        }
        catch (IOException e) {
            this.logger.error("shp.export.zip.error" + e.getLocalizedMessage());
            throw new RuntimeException("shp.export.zip.error" + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.error("shp.export.error" + e.getLocalizedMessage());
            FileUtil.delFileOrDirectory((String)folderPath);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return null;
    }

    public Double getGeometryArea(String wkt) {
        Geometry geometry = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        if (geometry != null) {
            if (geometry.getType().compareTo((Enum)Geometry.Type.Polygon) == 0) {
                return geometry.calculateArea2D();
            }
            return geometry.calculateLength2D();
        }
        return 0.0;
    }

    public String toGeoJSON(com.vividsolutions.jts.geom.Geometry geometry) {
        try {
            GeometryJSON geometryJSON = new GeometryJSON(14);
            StringWriter out = new StringWriter();
            geometryJSON.write(geometry, (Object)out);
            String str = "";
            return out.toString();
        }
        catch (IOException e) {
            throw new GeometryException(GeometryException.ExceptionType.GEOMETRY_TO_JSON_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public String toGeoJSON(Object geometry) {
        if (geometry instanceof com.vividsolutions.jts.geom.Geometry) {
            return this.toGeoJSON((com.vividsolutions.jts.geom.Geometry)geometry);
        }
        if (geometry instanceof SimpleFeature) {
            return this.toFeatureJSON(geometry);
        }
        if (geometry instanceof FeatureCollection) {
            return this.toFeatureJSON(geometry);
        }
        throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOMETRY_TO_JSON_EXCEPTION, "geometry not be supported");
    }

    public com.vividsolutions.jts.geom.Geometry readGeoJSON(String geojson) {
        try {
            GeometryJSON geometryJSON = new GeometryJSON();
            return geometryJSON.read((Object)geojson);
        }
        catch (IOException e) {
            throw new GeometryException(GeometryException.ExceptionType.GEOJSON_TO_GEOMETRY_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public com.vividsolutions.jts.geom.Geometry createValidGeometry(com.vividsolutions.jts.geom.Geometry geometry) {
        try {
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                GeometryFactory factory = geometry.getFactory();
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                Polygon exteriorPolygon = new Polygon((LinearRing)polygon.getExteriorRing(), null, factory);
                polygons.add(exteriorPolygon);
                for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                    LinearRing interiorRing = (LinearRing)polygon.getInteriorRingN(i);
                    Polygon interiorPolygon = new Polygon(interiorRing, null, factory);
                    polygons.add(interiorPolygon);
                }
                ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
                ArrayList<Polygon> excludePolygons = new ArrayList<Polygon>();
                for (Polygon temp : polygons) {
                    if (excludePolygons.contains(temp = this.getPolygonWithHoles(polygons, excludePolygons, temp))) continue;
                    newPolygons.add(temp);
                }
                return new MultiPolygon(newPolygons.toArray(new Polygon[0]), factory);
            }
            if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                ArrayList<Polygon> polygonList = new ArrayList<Polygon>();
                for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
                    if (!polygon.isValid()) {
                        MultiPolygon tempMultiPolygon = (MultiPolygon)this.createValidGeometry((com.vividsolutions.jts.geom.Geometry)polygon);
                        for (int k = 0; k < tempMultiPolygon.getNumGeometries(); ++k) {
                            polygonList.add((Polygon)tempMultiPolygon.getGeometryN(k));
                        }
                        continue;
                    }
                    polygonList.add(polygon);
                }
                return new MultiPolygon(polygonList.toArray(new Polygon[0]), multiPolygon.getFactory());
            }
            this.logger.info("geometryType has not been supported yet");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    private Polygon getPolygonWithHoles(List<Polygon> srcPolygons, List<Polygon> excludePolygons, Polygon polygon) {
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (Polygon item : srcPolygons) {
            if (polygon.equals((com.vividsolutions.jts.geom.Geometry)item) || excludePolygons.contains(polygon) || !polygon.contains((com.vividsolutions.jts.geom.Geometry)item)) continue;
            holes.add((LinearRing)item.getExteriorRing());
            excludePolygons.add(item);
        }
        if (holes.size() > 0) {
            return new Polygon((LinearRing)polygon.getExteriorRing(), holes.toArray(new LinearRing[0]), polygon.getFactory());
        }
        return polygon;
    }

    public FeatureCollection readFeatureCollectionJSON(String featureJSON) throws GeometryServiceException {
        try {
            FeatureJSON fJson = new FeatureJSON();
            return fJson.readFeatureCollection((Object)featureJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem readFeatureJSONCRS(String featureJSON) {
        try {
            FeatureJSON fJson = new FeatureJSON();
            return fJson.readCRS((Object)featureJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Map<String, Object> simpleFeature2Map(SimpleFeature feature) {
        Assert.notNull((Object)feature, (String)"feature can't be null");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Property property : feature.getProperties()) {
            if (property.getValue() == null) continue;
            result.put(property.getName().getLocalPart(), property.getValue());
        }
        return result;
    }

    public Map<String, Object> geoJSON2Map(String geoJSON, CoordinateReferenceSystem targetCRS) {
        Object geo = this.readUnTypeGeoJSON(geoJSON);
        Map<String, Object> columns = null;
        if (geo instanceof com.vividsolutions.jts.geom.Geometry) {
            columns = new HashMap<String, Object>();
            columns.put(SHAPE, ((com.vividsolutions.jts.geom.Geometry)geo).toText());
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
            if (Utils.isNull((Object)sourceCRS)) {
                sourceCRS = this.readFeatureJSONCRS(geoJSON);
            }
            columns = this.simpleFeature2Map(feature);
            try {
                for (String key : columns.keySet()) {
                    if (!(columns.get(key) instanceof com.vividsolutions.jts.geom.Geometry)) continue;
                    com.vividsolutions.jts.geom.Geometry geometry = (com.vividsolutions.jts.geom.Geometry)columns.get(key);
                    if (targetCRS != null && sourceCRS != null) {
                        geometry = this.project(geometry, sourceCRS, targetCRS);
                    }
                    columns.put(SHAPE, geometry.toText());
                    columns.remove(key);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage());
                throw new RuntimeException(e.getLocalizedMessage());
            }
        } else {
            if (geo instanceof GeometryCollection) {
                throw new RuntimeException("current omp version don't support GeometryCollection ");
            }
            if (geo instanceof FeatureCollection) {
                throw new RuntimeException("current omp version don't support FeatureCollection ");
            }
            throw new RuntimeException("geometry.undefined");
        }
        return columns;
    }

    public Point getGeometryCenter(com.vividsolutions.jts.geom.Geometry geometry) {
        assert (geometry != null);
        if (geometry instanceof Point) {
            return (Point)geometry;
        }
        return geometry.getCentroid();
    }

    public Object project(Object feature, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws GeometryServiceException {
        if (feature instanceof SimpleFeature) {
            String[] keys;
            SimpleFeature simpleFeature = (SimpleFeature)feature;
            String geometryField = simpleFeature.getFeatureType().getGeometryDescriptor().getLocalName();
            Map<String, Object> map = this.simpleFeature2Map(simpleFeature);
            com.vividsolutions.jts.geom.Geometry geometry = this.project((com.vividsolutions.jts.geom.Geometry)map.get(geometryField), sourceCRS, targetCRS);
            if (!geometry.isSimple() || this.validGeometry(geometry) != null && geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            SimpleFeatureType featureType = this.getFeatureType(map, targetCRS);
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
            for (String key : keys = map.keySet().toArray(new String[0])) {
                if (geometryField.equals(key)) {
                    featureBuilder.add((Object)geometry);
                    continue;
                }
                if (FEATURE_CRS.equals(key)) continue;
                featureBuilder.add(map.get(key) != null ? map.get(key) : "");
            }
            return featureBuilder.buildFeature(FEATURE.concat(UUIDGenerator.generate()));
        }
        if (feature instanceof FeatureCollection) {
            DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
            FeatureCollection featureCollection = (FeatureCollection)feature;
            FeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature temp = (SimpleFeature)featureIterator.next();
                collection.add((SimpleFeature)this.project(temp, sourceCRS, targetCRS));
            }
            featureIterator.close();
            return collection;
        }
        return null;
    }

    public String findTopoError(String geoJSON) throws Exception {
        TopologyValidationError error;
        Object geo = GeometryUtils.parseGeoJSON(geoJSON);
        if (geo instanceof com.vividsolutions.jts.geom.Geometry) {
            error = this.validGeometry((com.vividsolutions.jts.geom.Geometry)geo, true);
        } else if (geo instanceof SimpleFeature) {
            error = this.validGeometry((com.vividsolutions.jts.geom.Geometry)((SimpleFeature)geo).getDefaultGeometry(), true);
        } else {
            if (geo instanceof FeatureCollection) {
                FeatureCollection fc = (FeatureCollection)geo;
                ArrayList<String> errors = new ArrayList<String>(fc.size());
                FeatureIterator iterator = fc.features();
                while (iterator.hasNext()) {
                    boolean isFalseError;
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    TopologyValidationError error2 = this.validGeometry((com.vividsolutions.jts.geom.Geometry)feature.getDefaultGeometry(), true);
                    if (!Utils.isNotNull((Object)error2) || (isFalseError = error2.getErrorType() == 2 || error2.getErrorType() == 5 && !this.isRealSelfIntersection(error2.getCoordinate(), (com.vividsolutions.jts.geom.Geometry)feature.getDefaultGeometry()))) continue;
                    errors.add(JSON.toJSONString((Object)error2));
                }
                return errors.size() > 0 ? JSON.toJSONString(errors) : null;
            }
            throw new RuntimeException("This geometry type is unsupported!");
        }
        if (Utils.isNotNull((Object)error)) {
            return JSON.toJSONString((Object)error);
        }
        return null;
    }

    public com.vividsolutions.jts.geom.Geometry doTopologyValidation(com.vividsolutions.jts.geom.Geometry geo) {
        TopologyValidationError topoError = this.validGeometry(geo);
        if (!Utils.isNull((Object)topoError)) {
            if (topoError.getErrorType() == 2 || topoError.getErrorType() == 5 && !this.isRealSelfIntersection(topoError.getCoordinate(), geo)) {
                return this.createValidGeometry(geo);
            }
            throw new RuntimeException(JSON.toJSONString((Object)topoError));
        }
        return geo;
    }

    private boolean isRealSelfIntersection(Coordinate coordinate, com.vividsolutions.jts.geom.Geometry geo) {
        boolean result = true;
        double tolerance = 0.01;
        com.vividsolutions.jts.geom.Geometry newgeo = this.createValidGeometry(geo);
        ArrayList targetPolygons = Lists.newArrayList();
        if (newgeo != null && newgeo instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)newgeo;
            block0: for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
                Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
                List<Coordinate> coordinates = Arrays.asList(polygon.getCoordinates());
                Point targetPnt = this.geometryFactory.createPoint(coordinate);
                if (polygon.covers((com.vividsolutions.jts.geom.Geometry)targetPnt)) {
                    targetPolygons.add(polygon);
                    continue;
                }
                for (Coordinate coord : coordinates) {
                    if (!coord.equals2D(coordinate) && !(Math.abs(coord.distance(coordinate)) <= tolerance)) continue;
                    targetPolygons.add(polygon);
                    continue block0;
                }
            }
        }
        if (targetPolygons.size() > 1) {
            com.vividsolutions.jts.geom.Geometry duplicatedGeo = this.getDuplicatedGeo(targetPolygons, null);
            result = (duplicatedGeo instanceof Polygon || duplicatedGeo instanceof MultiPolygon || duplicatedGeo instanceof GeometryCollection) && !(duplicatedGeo instanceof MultiLineString) && !duplicatedGeo.isEmpty();
        }
        return result;
    }

    public com.vividsolutions.jts.geom.Geometry getDuplicatedGeo(List<com.vividsolutions.jts.geom.Geometry> geos, CoordinateReferenceSystem crs) {
        try {
            if (!Utils.isNull(geos) && geos.size() > 0) {
                com.vividsolutions.jts.geom.Geometry geo0 = geos.get(0);
                geos.remove(0);
                if (geos.size() == 0) {
                    return geo0;
                }
                if (Utils.isNull((Object)crs)) {
                    return geo0.intersection(this.getDuplicatedGeo(geos, null));
                }
                return this.readWKT(new AgsGeometryHelper().intersection(this.getDuplicatedGeo(geos, crs).toText(), geo0.toText(), crs.toWKT()));
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public String wkt2GeoJson(String wkt) {
        try {
            com.vividsolutions.jts.geom.Geometry geometry = this.readWKT(wkt);
            return this.toGeoJSON(geometry);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getLocalizedMessage());
        }
    }

    public List<com.vividsolutions.jts.geom.Geometry> featureCollectionToListGeometry(DefaultFeatureCollection defaultFeatureCollection) {
        SimpleFeatureIterator fi = defaultFeatureCollection.features();
        ArrayList<com.vividsolutions.jts.geom.Geometry> geometries = new ArrayList<com.vividsolutions.jts.geom.Geometry>();
        while (fi.hasNext()) {
            SimpleFeature sf = (SimpleFeature)fi.next();
            geometries.add((com.vividsolutions.jts.geom.Geometry)sf.getDefaultGeometry());
        }
        fi.close();
        return geometries;
    }
}

