/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.core.jtsgeo;

import cn.gtmap.gtcc.domain.gis.esm.Feature;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;

public class JTSGeometryFactory {
    private GeometryFactory geometryFactory;
    private final int MIN_COOR_SIZE = 2;

    public JTSGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public Geometry createGeometry(Feature.Geometry geo, boolean yCoordinateFirst) {
        String type = geo.getType();
        if ("Point".equalsIgnoreCase(type)) {
            return this.createPoint(geo.getCoordinates(), yCoordinateFirst);
        }
        if ("MultiPoint".equalsIgnoreCase(type)) {
            return this.createMultiPoint(geo.getCoordinates(), yCoordinateFirst);
        }
        if ("LineString".equalsIgnoreCase(type)) {
            return this.createLineString(geo.getCoordinates(), yCoordinateFirst);
        }
        if ("MultiLineString".equalsIgnoreCase(type)) {
            return this.createMultiLineString(geo.getCoordinates(), yCoordinateFirst);
        }
        if ("Polygon".equalsIgnoreCase(type)) {
            return this.createPolygon(geo.getCoordinates(), yCoordinateFirst);
        }
        if ("MultiPolygon".equalsIgnoreCase(type)) {
            return this.createMultiPolygon(geo.getCoordinates(), yCoordinateFirst);
        }
        throw new RuntimeException("Geometry type [" + type + "] not support");
    }

    public Geometry createGeometry(Feature.Geometry geo) {
        return this.createGeometry(geo, false);
    }

    private Coordinate createCoordinate(List<Double> coords, boolean yCoordinateFirst) {
        if (coords.size() < 2) {
            throw new RuntimeException("coordinates format error " + coords.size());
        }
        double x = coords.get(0);
        double y = coords.get(1);
        if (yCoordinateFirst) {
            double t = y;
            y = x;
            x = t;
        }
        return new Coordinate(x, y);
    }

    public Point createPoint(List<Double> coords, boolean yCoordinateFirst) {
        return this.geometryFactory.createPoint(this.createCoordinate(coords, yCoordinateFirst));
    }

    public MultiPoint createMultiPoint(List coords, boolean yCoordinateFirst) {
        ArrayList<Coordinate> cs = new ArrayList<Coordinate>();
        for (Object i1 : coords) {
            List c1 = (List)i1;
            cs.add(this.createCoordinate(c1, yCoordinateFirst));
        }
        return this.geometryFactory.createMultiPoint(cs.toArray(new Coordinate[0]));
    }

    public LineString createLineString(List coords, boolean yCoordinateFirst) {
        ArrayList<Coordinate> cs = new ArrayList<Coordinate>();
        for (Object i1 : coords) {
            List c1 = (List)i1;
            cs.add(this.createCoordinate(c1, yCoordinateFirst));
        }
        return this.geometryFactory.createLineString(cs.toArray(new Coordinate[0]));
    }

    public LinearRing createLinearRing(List coords, boolean yCoordinateFirst) {
        ArrayList<Coordinate> cs = new ArrayList<Coordinate>();
        for (Object i1 : coords) {
            List c1 = (List)i1;
            cs.add(this.createCoordinate(c1, yCoordinateFirst));
        }
        return this.geometryFactory.createLinearRing(cs.toArray(new Coordinate[0]));
    }

    public MultiLineString createMultiLineString(List coords, boolean yCoordinateFirst) {
        ArrayList<LineString> rings = new ArrayList<LineString>();
        for (Object i0 : coords) {
            List c0 = (List)i0;
            ArrayList<Coordinate> cs = new ArrayList<Coordinate>();
            for (Object i1 : c0) {
                List c1 = (List)i1;
                cs.add(this.createCoordinate(c1, yCoordinateFirst));
            }
            rings.add(this.createLineString(c0, yCoordinateFirst));
        }
        return this.geometryFactory.createMultiLineString(rings.toArray(new LineString[0]));
    }

    public Polygon createPolygon(List coords, boolean yCoordinateFirst) {
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
        for (Object i0 : coords) {
            List c0 = (List)i0;
            ArrayList<Coordinate> cs = new ArrayList<Coordinate>();
            for (Object i1 : c0) {
                List c1 = (List)i1;
                cs.add(this.createCoordinate(c1, yCoordinateFirst));
            }
            rings.add(this.createLinearRing(c0, yCoordinateFirst));
        }
        return this.geometryFactory.createPolygon((LinearRing)rings.get(0), rings.subList(1, rings.size()).toArray(new LinearRing[0]));
    }

    public MultiPolygon createMultiPolygon(List coords, boolean yCoordinateFirst) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Object i0 : coords) {
            List c0 = (List)i0;
            polygons.add(this.createPolygon(c0, yCoordinateFirst));
        }
        return this.geometryFactory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    public Geometry exchangeGeometryXYCoords(Geometry geometry) {
        if (geometry == null || geometry.isEmpty()) {
            return geometry;
        }
        geometry.apply(c -> {
            Coordinate cn = new Coordinate(c.y, c.x);
            c.setCoordinate(cn);
        });
        return geometry;
    }

    public Feature.Geometry fromGeometry(Geometry geometry) {
        Feature.Geometry geom = null;
        if (geometry instanceof Point) {
            geom = this.fromPoint((Point)geometry);
        } else if (geometry instanceof MultiPoint) {
            geom = this.fromMultiPoint((MultiPoint)geometry);
        } else if (geometry instanceof LineString) {
            geom = this.fromLineString((LineString)geometry);
        } else if (geometry instanceof MultiLineString) {
            geom = this.fromMultiLineString((MultiLineString)geometry);
        } else if (geometry instanceof Polygon) {
            geom = this.fromPolygon((Polygon)geometry);
        } else if (geometry instanceof MultiPolygon) {
            geom = this.fromMultiPolygon((MultiPolygon)geometry);
        }
        return geom;
    }

    public Feature.Geometry fromPoint(Point point) {
        Feature.Geometry geom = new Feature.Geometry();
        Coordinate coor = point.getCoordinate();
        ArrayList<Double> cr = new ArrayList<Double>();
        cr.add(coor.x);
        cr.add(coor.y);
        geom.setType("Point");
        geom.setCoordinates(cr);
        return geom;
    }

    private List fromCoordinates(Coordinate[] coors) {
        ArrayList pointList = new ArrayList();
        for (Coordinate coor : coors) {
            ArrayList<Double> cr = new ArrayList<Double>();
            cr.add(coor.x);
            cr.add(coor.y);
            pointList.add(cr);
        }
        return pointList;
    }

    public Feature.Geometry fromMultiPoint(MultiPoint multiPoint) {
        Feature.Geometry geom = new Feature.Geometry();
        geom.setType("MultiPoint");
        geom.setCoordinates(this.fromCoordinates(multiPoint.getCoordinates()));
        return geom;
    }

    public Feature.Geometry fromLineString(LineString line) {
        Feature.Geometry geom = new Feature.Geometry();
        geom.setType("LineString");
        geom.setCoordinates(this.fromCoordinates(line.getCoordinates()));
        return geom;
    }

    public Feature.Geometry fromMultiLineString(MultiLineString multiLineString) {
        Feature.Geometry geom = new Feature.Geometry();
        ArrayList<List> list = new ArrayList<List>();
        int num = multiLineString.getNumGeometries();
        for (int i = 0; i < num; ++i) {
            list.add(this.fromLineString((LineString)multiLineString.getGeometryN(i)).getCoordinates());
        }
        geom.setType("MultiLineString");
        geom.setCoordinates(list);
        return geom;
    }

    public Feature.Geometry fromPolygon(Polygon geometry) {
        Feature.Geometry geom = new Feature.Geometry();
        ArrayList<List> list = new ArrayList<List>();
        list.add(this.fromLineString(geometry.getExteriorRing()).getCoordinates());
        int num = geometry.getNumInteriorRing();
        for (int i = 0; i < num; ++i) {
            list.add(this.fromLineString(geometry.getInteriorRingN(i)).getCoordinates());
        }
        geom.setType("Polygon");
        geom.setCoordinates(list);
        return geom;
    }

    public Feature.Geometry fromMultiPolygon(MultiPolygon geometry) {
        Feature.Geometry geom = new Feature.Geometry();
        ArrayList<List> list = new ArrayList<List>();
        int num = geometry.getNumGeometries();
        for (int i = 0; i < num; ++i) {
            list.add(this.fromPolygon((Polygon)geometry.getGeometryN(i)).getCoordinates());
        }
        geom.setType("MultiPolygon");
        geom.setCoordinates(list);
        return geom;
    }
}

